<?php

/*-----------------------------------------------------------------------------------
- Default
----------------------------------------------------------------------------------- */

add_action( 'after_setup_theme', 'arstad_theme_setup' );

function arstad_theme_setup() {
	global $content_width;

	/* Set the $content_width for things such as video embeds. */
	if ( !isset( $content_width ) )
		$content_width = 750;

	/* Add theme support for automatic feed links. */
	add_theme_support( 'post-formats', array( 'video','audio', 'gallery','quote', 'link', 'aside' ) );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'custom-background' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-logo' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'responsive-embeds' );
	
	/* Add theme support for post thumbnails (featured images). */	
	add_theme_support('post-thumbnails');
	add_image_size('arstad_header', 1900, 750, true ); 	//(cropped)
	add_image_size('arstad_blog', 620, 400, true ); 	//(cropped)

	/* Add custom menus */
	register_nav_menus(array(
		'main-menu' => esc_html__( 'Main Menu','arstad' ),
		'bottom-menu' => esc_html__( 'Footer Menu','arstad' ),
	));

	/* Add your sidebars function to the 'widgets_init' action hook. */
	add_action( 'widgets_init', 'arstad_register_sidebars' );
	
	/* Make theme available for translation */
	load_theme_textdomain('arstad', get_template_directory() . '/lang' );

}

function arstad_register_sidebars() {
	
	register_sidebar(array('name' => esc_html__( 'Sidebar','arstad' ),'id' => 'dnnc-sidebar','description' => esc_html__( 'Sidebar widget section','arstad' ),'before_widget' => '<div class="sidebar_item">','after_widget' => '</div>','before_title' => '<h4 class="widget dnnc_border"><span>','after_title' => '</span></h4>'));

	//footer widgets
	register_sidebar(array('name' => esc_html__( 'Footer 1','arstad' ),'id' => 'dnnc-footer-1','description' => esc_html__( 'Widget section in footer - left','arstad' ),'before_widget' => '','after_widget' => '','before_title' => '<h4 class="widget dnnc_border small_title">','after_title' => '</h4>'));
	register_sidebar(array('name' => esc_html__( 'Footer 2','arstad' ),'id' => 'dnnc-footer-2','description' => esc_html__( 'Widget section in footer - center','arstad' ),'before_widget' => '','after_widget' => '','before_title' => '<h4 class="widget dnnc_border small_title">','after_title' => '</h4>'));
	register_sidebar(array('name' => esc_html__( 'Footer 3','arstad' ),'id' => 'dnnc-footer-3','description' => esc_html__( 'Widget section in footer - right','arstad' ),'before_widget' => '','after_widget' => '','before_title' => '<h4 class="widget dnnc_border small_title">','after_title' => '</h4>'));

}

	
/*-----------------------------------------------------------------------------------
- Framework - Please refrain from editing this section 
----------------------------------------------------------------------------------- */


// Set path to Framework and theme specific functions
$functions_path = get_template_directory() . '/functions/';

// Theme specific functionality
require_once ($functions_path . 'admin-functions.php');					// Custom functions and plugins

// Add Redux options panel
if ( !isset( $dannci_redux ) && file_exists( get_template_directory()  . '/redux-framework/redux-themnific.php' ) ) {
    require_once( get_template_directory()  . '/redux-framework/redux-themnific.php' );
}

	
/*-----------------------------------------------------------------------------------
- Enqueues scripts and styles for front end
----------------------------------------------------------------------------------- */ 

function arstad_enqueue_style() {
	
	// main stylesheet
	wp_enqueue_style('arstad-style', get_stylesheet_uri());
	
	// arstad mobile stylesheet
	wp_enqueue_style('arstad-mobile', get_template_directory_uri().'/style-mobile.css');
	
	// Font Awesome css	
	wp_enqueue_style('fontawesome', get_template_directory_uri() .	'/styles/fontawesome.css');
	
}
add_action( 'wp_enqueue_scripts', 'arstad_enqueue_style' );



function arstad_enqueue_script() {	

		// Load Common scripts	
		wp_enqueue_script('arstad-ownscript', get_template_directory_uri() .'/js/ownScript.js',array( 'jquery' ),'', true);		

		// Singular comment script		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
			wp_enqueue_script( 'comment-reply' );

}
	
add_action('wp_enqueue_scripts', 'arstad_enqueue_script');


/*-----------------------------------------------------------------------------------
- Include accessible
----------------------------------------------------------------------------------- */

include_once (get_template_directory() . '/functions/aria-walker-nav-menu.php');



/*-----------------------------------------------------------------------------------
- TGM_Plugin_Activation class.
----------------------------------------------------------------------------------- */
require_once get_template_directory()  . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'arstad_register_required_plugins' );
function arstad_register_required_plugins() {

    $plugins = array(
	

        // redux-framework
        array(
            'name'				=> esc_html__( 'Redux Framework','arstad' ),
            'slug'      		=> 'redux-framework',
            'required'  		=> true,
        ),
        // top-10
        array(
            'name'				=> esc_html__( 'Top 10','arstad' ),
            'slug'      		=> 'top-10',
            'required'  		=> false,
        ), 
        // classic-widgets
        array(
            'name'				=> esc_html__( 'Classic Widgets','arstad' ),
            'slug'      		=> 'classic-widgets',
            'required'  		=> false,
        ),
        // one-click-demo-import
        array(
            'name'				=> esc_html__( 'One Click Demo Import','arstad' ),
            'slug'      		=> 'one-click-demo-import',
            'required'  		=> false,
        ),

    );
    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins','arstad' ),
            'menu_title'                      => esc_html__( 'Install Plugins','arstad' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s','arstad' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.','arstad' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.','This theme requires the following plugins: %1$s.','arstad' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.','This theme recommends the following plugins: %1$s.','arstad' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.','arstad' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.','arstad' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.','arstad' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.','arstad' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.','arstad' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.','arstad' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins','arstad' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins','arstad' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer','arstad' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.','arstad' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s','arstad' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );

    tgmpa( $plugins, $config );

}

	
/*-----------------------------------------------------------------------------------
- Other theme functions
----------------------------------------------------------------------------------- */

// icons - font awesome
if ( ! function_exists ( 'arstad_icon' ) ) {
	function arstad_icon() {
		if(has_post_format('audio')) {return '<i title="'. esc_attr__('Audio','arstad').'" class="dnnc_icon fas fa-volume-up"></i>';
		}elseif(has_post_format('gallery')) {return '<i title="'. esc_attr__('Gallery','arstad').'" class="dnnc_icon fas fa-camera"></i>';
		}elseif(has_post_format('image')) {return '<i title="'. esc_attr__('Image','arstad').'" class="dnnc_icon fas fa-camera"></i>';	
		}elseif(has_post_format('link')) {return '<i title="'. esc_attr__('Link','arstad').'" class="dnnc_icon fas fa-link"></i>';			
		}elseif(has_post_format('quote')) {return '<i title="'. esc_attr__('Quote','arstad').'" class="dnnc_icon fas fa-quote-right"></i>';		
		}elseif(has_post_format('video')) {return '<i title="'. esc_attr__('Video','arstad').'" class="dnnc_icon fas fa-play-circle"></i>';
		} 	
	}
}


// new excerpt function
// Old Shorten Excerpt text for use in theme
function arstad_excerpt($text, $chars = 1620) {
	$text = $text." ";
	$text = substr($text,0,$chars);
	$text = substr($text,0,strrpos($text,' '));
	$text = $text."";
	return $text;
}

function arstad_trim_excerpt($text) {
     $text = str_replace('[', '', $text);
     $text = str_replace(']', '', $text);
     return $text;
    }
add_filter('get_the_excerpt', 'arstad_trim_excerpt');

// excerpt class
function arstad_class_to_excerpt( $excerpt ){
    return '<div class="dnnc_excerpt">'.$excerpt.'</div>';
}
add_action('the_excerpt','arstad_class_to_excerpt');


// meta sections
if ( ! function_exists ( 'arstad_meta_cat' ) ) {
	function arstad_meta_cat() { ?>   
		<p class="dnnc_meta dnnc_meta_categs <?php foreach((get_the_category()) as $category) {      echo esc_attr($category->slug) . '_category_color ';  } ?> <?php $dannci_redux = get_option( 'dannci_redux' ); if(isset($dannci_redux['dnnc-post-meta-dis']) ? $dannci_redux['dnnc-post-meta-dis'] : null) echo 'dnnc_hide';?>">
        <span class="categs"><?php the_category(' • ') ?></span>
		</p>
	<?php }
}

if ( ! function_exists ( 'arstad_meta_front' ) ) {
	function arstad_meta_front() { ?>    
		<p class="dnnc_meta <?php $dannci_redux = get_option( 'dannci_redux' ); if(isset($dannci_redux['dnnc-post-meta-dis']) ? $dannci_redux['dnnc-post-meta-dis'] : null) echo 'dnnc_hide';?>">
			<span class="post-date"><span class="on_in_by"><?php esc_html_e('On','arstad');?></span><?php the_time(get_option('date_format')); ?><span class="meta_divider">&bull;</span></span>
			<span class="categs"><span class="on_in_by"><?php esc_html_e('In','arstad');?></span><?php the_category(' • ') ?><span class="meta_divider">&bull;</span></span>	
            <?php 
				echo '<span class="author">';
				echo '<span class="on_in_by">' ;
				esc_html_e('by','arstad') ;
				echo '</span>'; 
				the_author_posts_link();
				echo '</span>';
			?>
		</p>
	<?php
	}
}

if ( ! function_exists ( 'arstad_meta_full' ) ) {
	function arstad_meta_full() { ?>    
		<p class="dnnc_meta dnnc_meta_full <?php $dannci_redux = get_option( 'dannci_redux' ); if(isset($dannci_redux['dnnc-post-meta-dis']) ? $dannci_redux['dnnc-post-meta-dis'] : null) echo 'dnnc_hide';?>">
			<span class="post-date"><?php the_time(get_option('date_format')); ?><span class="meta_divider">&bull;</span></span>
			<span class="categs"><?php the_category(', ') ?><span class="meta_divider">&bull;</span></span>
			<?php echo '<span class="author">'; the_author_posts_link();echo '</span>';	?>
		</p>
	<?php
	}
}

if ( ! function_exists ( 'arstad_meta_more' ) ) {
	function arstad_meta_more() { ?>   
        <p class="dnnc_meta dnnc_meta_more tranz">
            <a class="link--forsure" href="<?php the_permalink() ?>"><?php esc_html_e('Read More','arstad');?></a>
        </p>
	<?php }
}



// menu description
function arstad_nav_description( $item_output, $item, $depth, $args ) {
    if ( !empty( $item->description ) ) {
        $item_output = str_replace( $args->link_after . '</a>', '<span class="menu-item-description tranz">' . $item->description . '</span>' . $args->link_after . '</a>', $item_output );
    }
 
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'arstad_nav_description', 10, 4 );

//author box - additional links
if ( ! function_exists ( 'arstad_new_contactmethods' ) ) {
	function arstad_new_contactmethods( $contactmethods ) {
		$contactmethods['twitter'] = 'Twitter';
		$contactmethods['facebook'] = 'Facebook';
		$contactmethods['linkedin'] = 'LinkedIn';
		$contactmethods['pinterest'] = 'Pinterest';
		$contactmethods['instagram'] = 'Instagram';
		$contactmethods['link'] = 'Any Link';
		return $contactmethods;
	}
	add_filter('user_contactmethods','arstad_new_contactmethods',10,1);
}



// register custom fonts for Gutenberg
function arstad_gutenberg_styles() {

	// Load the theme styles within Gutenberg.
	wp_enqueue_style( 'arstad-gutenberg', get_theme_file_uri( '/styles/style-editor.css' ), false, '1.1.1', 'all' );

	// Add custom fonts to Gutenberg.
	wp_enqueue_style( 'arstad-fonts', arstad_admin_fonts_url(), array(), null );
}
add_action( 'enqueue_block_editor_assets', 'arstad_gutenberg_styles' );
// register custom fonts.
function arstad_admin_fonts_url() {
	$fonts_url = '';
	$firstfont = esc_html_x( 'on', 'Cormorant Garamond font: on or off', 'arstad' );
	$secondfont = esc_html_x( 'on', 'Cardo: on or off', 'arstad' );

	if ( 'off' !== $firstfont || 'off' !== $secondfont ) {
		$font_families = array();

		if ( 'off' !== $firstfont ) {
			$font_families[] = 'Cormorant Garamond:400,500,600,700,800,400i';
		}

		if ( 'off' !== $secondfont ) {
			$font_families[] = 'Cardo:400,400i,500,600,700';
		}

		$query_args = array(
			'family' => rawurlencode( implode( '|', $font_families ) ),
			'subset' => rawurlencode( 'latin,latin-ext' ),
		);

		$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}

// span to default widgets
function arstad_cat_count_span($links) {
  $links = str_replace('</a> (', '</a> <span class="cat_nr dnnc_rad_big">', $links);
  $links = str_replace(')', '</span>', $links);
  return $links;
}
add_filter('wp_list_categories', 'arstad_cat_count_span');



function arstad_archive_count($links) {
    $links = str_replace('</a>&nbsp;(', '</a> <span class="cat_nr">', $links);
    $links = str_replace(')', '</span>', $links);
    return $links;
}
add_filter('get_archives_link', 'arstad_archive_count');

// thumbnail for admin
/////////// 
// thumbnail for admin: section 1.
function arstad_get_featured_image($post_ID) {  
    $post_thumbnail_id = get_post_thumbnail_id($post_ID);  
    if ($post_thumbnail_id) {  
        $post_thumbnail_img = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail');  
        return $post_thumbnail_img[0];  
    }  
} 
// thumbnail for admin: section 2. ADD NEW COLUMN  
function arstad_columns_head($defaults) {  
	$defaults['featured_image'] = 'Featured Image';  
	return $defaults;  
}  
// thumbnail for admin: section 3. SHOW THE FEATURED IMAGE  
function arstad_columns_content($column_name, $post_ID) {  
	if ($column_name == 'featured_image') {  
		$post_featured_image = arstad_get_featured_image($post_ID);  
		if ($post_featured_image) {  
			echo '<img style=" width:100px;" src="' . $post_featured_image . '" />';  
		}  
	}  
}  
add_filter('manage_posts_columns', 'arstad_columns_head');  
add_action('manage_posts_custom_column', 'arstad_columns_content', 10, 2); 

/* That's all! */
?>