<?php

/*-----------------------------------------------------------------------------------*/
/* REDUX - speciable */
/*-----------------------------------------------------------------------------------*/



// detect plugin 
if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
} else {
	
	function arstad_enqueue_reduxfall() {
		
		// Redux fallback
		wp_enqueue_style('reduxfall', get_template_directory_uri() . '/styles/reduxfall.css');
	
		// google link
		function dnnc_fonts_url() {
			$font_url = '';
			if ( 'off' !==  esc_attr_x( 'on', 'Google font: on or off','arstad')) {
				$font_url = add_query_arg( 'family', urlencode( 'Cormorant Garamond:400,500,600,700,400italic,700italic&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
			}
			return $font_url;
		}
		wp_enqueue_style( 'dnnc-fonts', dnnc_fonts_url(), array(), '1.0.0' );
		
	}
	add_action( 'wp_enqueue_scripts', 'arstad_enqueue_reduxfall' );
	
}



add_action('wp_footer', 'dnnc_bck_lnk');
function dnnc_bck_lnk(){ ?>
	<div class="dnnc_bck_lnk dnnc_border">
    <div class="dnnc_container">
      <a class="bck_lnk" target="_blank" title="Minimalistic WordPress Themes" href="http://dannci.com">Designed by Dannci</a>
    </div>
  </div>
<?php };

// one click import - detect plugin 
if ( class_exists( 'OCDI_Plugin' ) ) {

function dnnc_import_files() {
  return array(
  
  
  	// DEFAULT
    array(
      'import_file_name'           	=> 	'Default Demo',
      'import_file_url'            	=> 	'https://dannci.com/import/arstad/arstad.xml',
      'import_widget_file_url'     	=> 	'https://dannci.com/import/arstad/arstad-widgets.wie',
      'import_redux' => array(
				  array(
					'file_url'    	=> 	'https://dannci.com/import/arstad/arstad-redux.json',
					'option_name' 	=> 	'dannci_redux',
				  ),
      ),
      'import_preview_image_url'   	=> 	'https://dannci.com/import/arstad/arstad-screenshot.png',
      'preview_url'                	=> 	'https://dannci.com/demo/arstad/',
    ),

	
	
	
	
	// END OF ARRAY
	
  );
}
add_filter( 'pt-ocdi/import_files', 'dnnc_import_files' );

// required/recommended plugins
function tmnf_register_plugins( $plugins ) {
  $theme_plugins = [
  
    [ // redux-framework
      'name'     => 'Redux Framework',
      'slug'     => 'redux-framework',
      'required' => true,
    ],
    [ // wp-featherlight
        'name'     => 'WP Featherlight Lightbox',
        'slug'     => 'wp-featherlight',
        'required' => false,
      ],
    [ // classic-widgets
      'name'     => 'Classic Widgets',
      'slug'     => 'classic-widgets',
      'required' => false,
      ],
	
  ];
 
  return array_merge( $plugins, $theme_plugins );
}
add_filter( 'ocdi/register_plugins', 'tmnf_register_plugins' );



function dnnc_after_import_setup() {
    $main_menu = get_term_by( 'name', 'Main menu', 'nav_menu' );
    $bottom_menu = get_term_by( 'name', 'Footer menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'main-menu' => $main_menu->term_id,
            'bottom-menu' => $bottom_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'News' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'dnnc_after_import_setup' );

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

}

/*-----------------------------------------------------------------------------------*/
/* THE END */
/*-----------------------------------------------------------------------------------*/
?>