<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head><meta charset="<?php bloginfo( 'charset' ); ?>">

<!-- Set the viewport width to device width for mobile -->
<meta name="viewport" content="width=device-width, initial-scale=1" />

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php wp_head(); ?>

</head>

     
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<?php $dannci_redux = get_option( 'dannci_redux' ); if(empty($dannci_redux['dnnc-main-logo']['url'])) {  } else { ?>
                            
    <a class="dnnc_logo" href="<?php echo esc_url(home_url('/')); ?>">
    
        <img class="tranz this_is_logo" src="<?php echo esc_url($dannci_redux['dnnc-main-logo']['url']);?>" alt="<?php bloginfo('name'); ?>"/>
            
    </a>
            
<?php } ?>

<div class="wrapper_main <?php $dannci_redux = get_option( 'dannci_redux' ); 
	if (!empty($dannci_redux['dnnc-uppercase']))  {echo esc_attr($dannci_redux['dnnc-uppercase']) . ' ';}
	if ( is_active_sidebar( 'dnnc-sidebar' ) ) {echo 'dnnc_sidebar_active ';} else { echo 'dnnc_sidebar_null ';};
?>">
   
    <div id="header" class="dnnc_tranz" itemscope itemtype="http://schema.org/WPHeader">
            
        <a class="screen-reader-text ribbon skip-link" href="#content_start"><?php esc_html_e('Skip to content','arstad');?></a>


    
    	<div class="dnnc_container dnnc_container_head">
        
            <div class="head_inn">
                
                <div id="titles" class="tranz2">

                    <h1 class="logo"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name');?></a></h1>
                
                </div><!-- end #titles  -->
                
                <div class="header-right for-menu <?php if ( has_nav_menu( 'main-menu' ) ) {echo 'show-menu-visible';}?>">
                
                    <input type="checkbox" id="showmenu" aria-label="<?php esc_html_e('Open Menu','arstad');?>">
                    <label for="showmenu" class="show-menu ribbon" tabindex="0"><i class="fas fa-bars"></i> <span><?php esc_html_e('Menu','arstad');?></span></label>
               
                    <nav id="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement" role="navigation" aria-label="<?php esc_html_e( 'Main Menu', 'arstad' ); ?>"> 
                        
                        <?php get_template_part('/includes/navigation'); ?> 
                        <?php get_template_part('/includes/social-icons' ); ?> 
                    
                    </nav>
                
                </div><!-- end .header-right  -->
                
            </div><!-- end .dnnc_column_12  -->
            
        </div><!-- end .dnnc_container  -->
    
    <div class="clearfix"></div>
    </div><!-- end #header  -->

<div class="clearfix"></div>
<div class="wrapper dnnc_border">