<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "dannci_redux";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme admin panel', 'arstad' ),
        'page_title'           => __( 'Theme admin panel', 'arstad' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    


    $args['admin_bar_links'][] = array(
        'href'   => 'https://www.buymeacoffee.com/dannci',
        'target'   => '_blank',
        'title' => esc_html__( 'Buy Me a Coffee', 'arstad' ),
    );
    $args['admin_bar_links'][] = array(
                    'href'   => 'http://dannci.com/docs',
					'target'   => '_blank',
                    'title' => esc_html__( 'Documentation', 'arstad' ),
    );

    // Add content after the form.
    $args['footer_text'] = __( '<p>I recommend <a href="http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979" target="_blank">DreamHost for hosting</a> your WordPress website. <a href="#">Get PRO with DIVI</a></p>', '' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    // -> START Fields
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'General Settings','arstad' ),
                    'desc'   => esc_html__( '','arstad' ),
                    'icon'   => 'el el-cogs',
                    'fields' => array( // header end
					

                        array(
                            'id'       => 'dnnc-main-logo',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo','arstad' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','arstad' ),
                        ),		

						array(
                            'id'       => 'dnnc-header-image',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Header image', 'arstad' ),
                            'subtitle'     => esc_html__( 'Upload a "header" image for blog and archives.', 'arstad' ),
                        ),
						
						array(
                            'id'       => 'dnnc-blog-layout',
                            'type'     => 'radio',
                            'title'    => esc_html__('Blog Layout','arstad'),
                            'subtitle' => esc_html__('Select layout and styling for the blog template','arstad'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'dnnc_blogger_sidebar' => esc_html__('With Sidebar','arstad'),
                                'dnnc_blogger_full_width' => esc_html__('Without Sidebar','arstad'),
                            ),
                            'default'  => 'dnnc_blogger_sidebar'
                        ),
						
												
                      	array(
                            'id'       => 'dnnc-uppercase',
                            'type'     => 'radio',
                            'title'    => esc_html__('Uppercase Fonts','arstad'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'upper_none' => esc_html__('None','arstad'),
                                'upper' => esc_html__('Minimal','arstad'),
                                'upper upper_medium' => esc_html__('Medium','arstad'),
                            ),
                            'default'  => 'upper'
                        ),
						
						
                    )
					
					// section end
    ) );
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Primary Styling','arstad' ),
                    'desc'   => esc_html__( '','arstad' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end



						array(
                            'id'          => 'arstad-body-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Typography','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
							'all_styles'  => true,
                            'output'      => array( 'body,input,button,select,textarea,#wpmem_reg fieldset,#wpmem_login fieldset' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as the general text.','arstad' ),
                            'default'     => array(
                                'color'       => '#383a3a',
                                'font-style'  => '400',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),

                        array(
                            'id'       => 'arstad-background',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Main Body Background','arstad' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','arstad' ),
							'transparent' => false,
                            'output'   => array('body,.dnnc_blogger .item_inn' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),
						
						array(
							'id'        => 'arstad-color-dnnc_ghost',
							'type'      => 'color',
							'title'     => esc_html__('Ghost Background Color','arstad'),
							'subtitle'  => esc_html__('Pick an alternative background color (similar to Main Body Background)','arstad'),
							'transparent' => false,
							'default'   => '#f9f9f9',
							'output'    => array(
								'background-color' => '.dnnc_ghost,.single .give-goal-progress,#comments .navigation a,a.page-numbers,.page-numbers.dots'
							)
						),

                        array(
                            'id'       => 'arstad-link-color',
                            'type'     => 'link_color',
                            'title'    => esc_html__( 'Links Color Option','arstad' ),
                            'subtitle' => esc_html__( 'Pick a link color','arstad' ),
							'output'   => array( 'a' ),
                            'default'  => array(
                                'regular' => '#000',
                                'hover'   => '#ff5745',
                                'active'  => '#000',
                            )
                        ),
						

						
						array(
							'id'        => 'arstad-color-entry-link',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts)','arstad'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','arstad'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_entry p a,.dnnc_entry ol a,.dnnc_entry ul a,.elementor-text-editor a',
							)
						),
						

						
						array(
							'id'        => 'arstad-color-entry-link-hover',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts): Hover Background Color','arstad'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','arstad'),
							'transparent' => false,
							'default'   => '#555',
							'output'    => array(
								'background-color' => '.dnnc_entry p a:hover,.dnnc_entry li a:hover',
							)
						),
						
                        array(
                            'id'       => 'arstad-primary-border',
							'type'      => 'color',
							'title'     => esc_html__('Borders Color','arstad'),
							'subtitle'  => esc_html__('Pick a color for primary borders','arstad'),
							'transparent' => false,
							'default'   => '#ededed',
							'output'    => array(
								'border-color' => '.dnnc_border,.event_header p,input, textarea,select,.sidebar_item,.sidebar_item li,.comment-body,.tagcloud a,.page-numbers,.nav_item a,.dnnc_tags a',
							)
						),
						
						array(
							'id'        => 'arstad-text-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Text Color','arstad'),
							'subtitle'  => esc_html__('Pick a color for sidebar text.','arstad'),
							'transparent' => false,
							'default'   => '#939597',
							'output'    => array(
								'color' => '#sidebar,.post-pagination span',
							)
						),
						
						array(
							'id'        => 'arstad-links-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link Color','arstad'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','arstad'),
							'transparent' => false,
							'default'   => '#000000',
							'output'    => array(
								'color' => '.widgetable a',
							)
						),
						
						array(
							'id'        => 'arstad-links-sidebar-hover',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link: Hover Color','arstad'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','arstad'),
							'transparent' => false,
							'default'   => '#666',
							'output'    => array(
								'color' => '.widgetable a:hover',
							)
						),
                    )

					// section end
    ) );
	// Primary styling THE END
	
	
	
	
	
	
	// HEADER STYLING
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Header Styling','arstad' ),
                    'desc'   => esc_html__( '','arstad' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end

                        array(
                            'id'       => 'arstad-bg-header',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Header: Background','arstad' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','arstad' ),
							'transparent' => false,
                            'output'   => array('#header' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),
						
						array(
							'id'        => 'nordkapdnnc_borders-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Header Borders Color','arstad'),
							'transparent' => false,
							'default'   => '#eee',
							'output'    => array(
								'border-color' => '.head_inn,#header .dnnc_social_icons li a',
							)
						),


						array(
                            'id'          => 'arstad-site-title',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Site Title','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1.logo,h1.logo a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),

						array(
                            'id'          => 'arstad-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Navigation Typography','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav>li>a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','arstad' ),
                            'default'     => array(
                                'color'       => '#444444',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '21px',
                            ),
                        ),
						
						array(
							'id'        => 'arstad-hover-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Navigation Links: Hover Color','arstad'),
							'subtitle'  => esc_html__('Pick a hover color for header links.','arstad'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'border-color' => '.nav li.current-menu-item>a,.nav >li>a:hover,#main-nav li.current-menu-ancestor>a',
							)
						),
						

					
						array(
							'id'   => 'info_submenu',
							'type' => 'info',
							'title' => esc_html__('Sub-menu + Special menu button','arstad'),
							'style' => 'success',
						),
						
						
						
						array(
							'id'        => 'arstad-sub-bg-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Sub-menu Background Color','arstad'),
							'subtitle'  => esc_html__('Pick a color for header text.','arstad'),
							'transparent' => false,
							'default'   => '#4e5466',
							'output'    => array(
								'background-color' => '.nav li ul',
								'border-left-color' => '.nav>li>ul:after,.nav > li.mega:hover::after',
								'border-right-color' => 'body.rtl .nav>li>ul:after,body.rtl .nav > li.mega:hover::after',
							)
						),


						array(
                            'id'          => 'arstad-sub-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Sub-menu Typography','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav ul li>a,.dnnc_tagline' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','arstad' ),
                            'default'     => array(
                                'color'       => '#dce1ed',
                                'font-weight'  => '400',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),
						

						
						
						array(
							'id'        => 'arstad-special-bg',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Background Color','arstad'),
							'transparent' => false,
							'default'   => '#4e5466',
							'output'    => array(
								'background-color' => '#main-nav>li.special>a',
							)
						),
						
						array(
							'id'        => 'arstad-special-bg-hover',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Hover Background Color','arstad'),
							'transparent' => false,
							'default'   => '#939597',
							'output'    => array(
								'background-color' => '#main-nav>li.special>a:hover',
							)
						),
						
						
						array(
							'id'        => 'arstad-special-text',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Text Color','arstad'),
							'transparent' => false,
							'default'   => '#dce1ed',
							'output'    => array(
								'color' => '#main-nav>li.special>a,#main-nav>li.special>a:hover i',
							)
						),
						
						
						array(
							'id'        => 'arstad-special-icon',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Icon Color','arstad'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '#main-nav>li.special>a i',
							)
						),


						array(
							'id'   => 'info_spacing',
							'type' => 'info',
							'title' => esc_html__('Spacing of the Header','arstad'),
							'style' => 'success',
						),

                        array(
                            'id'             => 'arstad-width-header',
                            'type'           => 'dimensions',
                            'output'   => array( '#titles' ),
                            'units'          => 'px', 
                            'units_extended' => 'true',  
                            'height'          => false, 
                            'title'          => esc_html__( 'Header Title/Logo Width Option','arstad' ),
                            'subtitle'       => esc_html__( 'Choose the width limitation for the header logo.','arstad' ),
                            'default'        => array(
                                'width'  => '180px',
                            )
                        ),

                        array(
                            'id'       => 'arstad-spacing-header',
                            'type'     => 'spacing',
                            'output'   => array( '#titles .logo' ),
                            'mode'     => 'margin',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Title/Logo Spacing','arstad' ),
                            'subtitle' => esc_html__( 'Choose the margin for the header logo.','arstad' ),
                            'default'  => array(
                                'margin-top'    => '40px',
                                'margin-bottom' => '38px',
                            )
                        ),
						

                        array(
                            'id'       => 'arstad-spacing-nav',
                            'type'     => 'spacing',
                            'output'   => array( '#navigation>ul' ),
                            'mode'     => 'padding',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Navigation Spacing','arstad' ),
                            'subtitle' => esc_html__( 'Choose the margin for header navigation.','arstad' ),
                            'default'  => array(
                                'padding-top'    => '34px',
                                'padding-bottom' => '31px',
                            )
                        ),

                    )
					// section end
    ) );
	// header styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Footer Styling','arstad' ),
                    'desc'   => esc_html__( '','arstad' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
						array(
							'id'        => 'arstad-color-myfooter',
							'type'      => 'background',
							'title'     => esc_html__('Footer: Background Color','arstad'),
							'subtitle'  => esc_html__('Pick a background color for the footer.','arstad'),
							'transparent' => false,
                            'output'   => array('#footer,#footer .searchform input.s,.dnnc_bck_lnk' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
						),
						
						array(
							'id'        => 'arstad-text-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Text: Color','arstad'),
							'subtitle'  => esc_html__('Pick a color for footer links.','arstad'),
							'transparent' => false,
							'default'   => '#737d89',
							'output'    => array(
								'color' => '#footer p,#footer,#footer h4,#footer .bottom-menu a,.dnnc_bck_lnk,.dnnc_bck_lnk a',
							)
						),
						
						array(
							'id'        => 'arstad-links-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Color','arstad'),
							'subtitle'  => esc_html__('Pick a color for footer links.','arstad'),
							'transparent' => false,
							'default'   => '#4c5154',
							'output'    => array(
								'color' => '#footer a,#footer a span,#footer h2,#footer h3,#footer .meta,#footer .meta a,#footer .searchform input.s,.footop ul.social-menu li span',
							)
						),
						
						array(
							'id'        => 'arstad-hover-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Hover Color','arstad'),
							'subtitle'  => esc_html__('Pick a hover color for footer links.','arstad'),
							'transparent' => false,
							'default'   => '#8ca1af',
							'output'    => array(
								'color' => '#footer a:hover,#footer a:hover span',
							)
						),
						
						
                        array(
                            'id'       => 'arstad-footer-border',
							'type'      => 'color',
							'title'     => esc_html__('Footer: Borders','arstad'),
							'subtitle'  => esc_html__('Pick a color for footer borders.','arstad'),
							'transparent' => false,
							'default'   => '#f2f2f2',
							'output'    => array(
								'border-color' => '#footer .dnnc_border,.dnnc_bck_lnk,.dnnc_foocol li,#footer a,#footer .dnnc_social_icons li a,#footer .searchform input.s,#footer input',
							)
						), 
						
						array(
							'id'   => 'info_special_footer',
							'type' => 'info',
							'title' => esc_html__('Special Footer Section (above the footer)','arstad'),
							'style' => 'success',
						),	
						
						
						array(
							'id'        => 'arstad-bg-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Background Color','arstad'),
							'subtitle'  => esc_html__('Pick a background color for Special Footer.','arstad'),
							'transparent' => false,
							'default'   => '#abc7d5',
							'output'    => array(
								'background-color' => '.footop .dnnc_container',
							)
						),
						
						
						array(
							'id'        => 'arstad-text-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Text / links Color','arstad'),
							'subtitle'  => esc_html__('Pick a text color for Special Footer.','arstad'),
							'transparent' => false,
							'default'   => '#4c5154',
							'output'    => array(
								'color' => '#footop h2,.footop-left a,#foo-spec,#footer .dnnc_social_icons li a:hover,#footer .dnnc_social_icons li a:hover span',
							)
						),


			
						array(
                            'id'       => 'dnnc-footer-editor',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Text','arstad' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','arstad' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','arstad' ),
							'default'  => 'A sustainable future through digitalization.',
                            'validate' => 'html',
						),
						
						array(
                            'id'       => 'dnnc-footer-credits',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Credits Text','arstad' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','arstad' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','arstad' ),
							'default'  => 'Copyright © 2023 - Årstad Theme',
                            'validate' => 'html',
						),
                    )

					// section end
    ) );
	// footer styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(                    
					'title'  => esc_html__( 'Typography','arstad' ),
                    'desc'   => esc_html__( '','arstad' ),
                    'icon'   => 'el el-bold',
                    'fields' => array( // header end
						
						
						array(
							'id'   => 'info_titles',
							'type' => 'info',
							'title' => esc_html__('Titles','arstad'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'arstad-large',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Large Titles','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.large_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '55px',
                            ),
                        ),


						array(
                            'id'          => 'arstad-medium',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Medium Titles','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.medium_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),


						array(
                            'id'          => 'arstad-small',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Small Titles','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.small_title,.post_nav_text,.tptn_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '21px',
                            ),
                        ),
						
						


						array(
                            'id'          => 'arstad-buttons',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Buttons Typography','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#submit,.dnnc_social_icons li a span,.mainbutton,.dnnc_foocol h4.widget' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						
						
						
						array(
							'id'   => 'info_headings',
							'type' => 'info',
							'title' => esc_html__('Basic (in post) Headings','arstad'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'arstad-h1',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H1 Font Style','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H1.','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '46px',
                            ),
                        ),
						
						array(
                            'id'          => 'arstad-h2',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H2 Font Style','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h2,blockquote' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H2.','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '36px',
                            ),
                        ),
						
						array(
                            'id'          => 'arstad-h3',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H3 Font Style','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h3' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H3.','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '32px',
                            ),
                        ),
						
						array(
                            'id'          => 'arstad-h4',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H4 Font Style','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h4' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H4.','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),
						
						array(
                            'id'          => 'arstad-h5',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H5 Font Style','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h5,h6' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H5.','arstad' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
                    )

					// section end
    ) );
	// typography styling THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Other Styling','arstad' ),
                    'desc'   => esc_html__( '','arstad' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
	
						
						array(
                            'id'          => 'arstad-meta',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Meta Sections: Font Style','arstad' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.dnnc_meta,.crumb,.post_nav_text span,.dnnc_tags a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for meta sections.','arstad' ),
                            'default'     => array(
                                'color'       => '#a8afaf',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant Garamond',
                                'google'      => true,
                                'font-size'   => '11px',
                            ),
                        ),
						
						array(
							'id'        => 'arstad-meta-links',
							'type'      => 'color',
							'title'     => esc_html__('Meta Sections: Links Color','arstad'),
							'transparent' => false,
							'default'   => '#4c5154',
							'output'    => array(
								'color' => '.dnnc_meta a'
								
							)
						),
						
						array(
							'id'        => 'arstad-color-dividers',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Background','arstad'),
							'transparent' => false,
							'default'   => '#abc7d5',
							'output'    => array(
								'background-color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs,.dnnc_social_icons li a:hover,.dnnc_foocol::before',
								'color' => '.main-breadcrumbs span::after'
								
							)
						),
						
						array(
							'id'        => 'arstad-color-dividers-text',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Text','arstad'),
							'transparent' => false,
							'default'   => '#4e5466',
							'output'    => array(
								'color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs,.dnnc_meta_categs a,.dnnc_social_icons li a:hover',
								
							)
						),
						
						array(
							'id'        => 'arstad-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Color','arstad'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','arstad'),
							'transparent' => false,
							'default'   => '#4e5466',
							'output'    => array(
								'background-color' => '.ribbon,a.mainbutton,.cat_nr,#respond #submit,.page-numbers.current,#submit,input[type="submit"],input.button,button.submit,#comments .navigation a,.reply a,.post_pagination_inn',
								'border-color' => 'input.button,button.submit,.page-link>span',
								
							)
						),
						
						array(
							'id'        => 'arstad-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Color','arstad'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','arstad'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '.ribbon,.ribbon a,a.ribbon,.ribbon p,#footer .ribbon,a.mainbutton,.cat_nr,.page-numbers.current,.format-quote blockquote,.reply a,#respond #submit,input[type="submit"],.post_pagination p a span',
							)
						),
						
						array(
							'id'        => 'arstad-hover-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Hover Color','arstad'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','arstad'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'background-color' => 'a.searchSubmit:hover,.ribbon:hover,a.mainbutton:hover,.meta_more a:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,h4.widget>span:after,.post_pagination p a:hover span,.owl-nav>div:hover',
								'border-color' => 'input.button:hover,button.submit:hover,.dnnc_tags a:hover'
							)
						),
						
						array(
							'id'        => 'arstad-hover-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Hover Color','arstad'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','arstad'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '#footer a.mainbutton:hover,.ribbon:hover,.ribbon:hover a,.ribbon a:hover,.ribbon:hover p,.entry a.ribbon:hover,a.mainbutton:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,.post_pagination p a:hover span,.owl-nav>div:hover',
							)
						),
						
						
						array(
							'id'        => 'arstad-images-bg',
							'type'      => 'color',
							'title'     => esc_html__('Images Background Color','arstad'),
							'subtitle'  => esc_html__('Pick a custom background color for images.','arstad'),
							'transparent' => false,
							'default'   => '#1E1E1E',
							'output'    => array(
								'background-color' => '.imgwrap,.dnnc_page_header_image,.post_nav_image',
							)
						),
						
						
						
						array(
							'id'        => 'arstad-images-text',
							'type'      => 'color',
							'title'     => esc_html__('Images Text/Link Color','arstad'),
							'subtitle'  => esc_html__('Pick a custom text color for image texts (overlay)','arstad'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '.dnnc_page_header_image,.dnnc_page_header_image p,.dnnc_page_header_image a,.dnnc_page_header_image h1,.post_nav_image .arrow',
							)
						),
                    )
					// section end
    ) );
	// other styling THE END
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
	//POST SETTINGS
    Redux::setSection( $opt_name, array(
                   'title'  => esc_html__( 'Post Settings','arstad' ),
                    'desc'   => esc_html__( '','arstad' ),
                    'icon'   => 'el el-edit',
                    'fields' => array( // header end

						
                        array(
                            'id'       => 'dnnc-post-meta-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Disable "Meta" sections','arstad' ),
                            'subtitle' => esc_html__( 'Tick to disable post "information" - date, category, etc. below post titles','arstad' ),
                            'desc'     => esc_html__( '','arstad' ),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-author-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Author Box','arstad' ),
                            'desc'     => esc_html__( '','arstad' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-tags-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Tags Section','arstad' ),
                            'desc'     => esc_html__( '','arstad' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-related-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Related Post Section','arstad' ),
                            'desc'     => esc_html__( '','arstad' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
                    )
					// section end
    ) );
	// post settings THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Social Networks','arstad'),
                    'icon'   => 'el el-share',
                    'fields' => array( // header end
				
					

                        array(
                            'id'       => 'dnnc-social-rss',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Rss Feed','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
                        array(
                            'id'       => 'dnnc-social-facebook',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Facebook','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-twitter',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Twitter','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tiktok',
                            'type'     => 'text',
                            'title'    => esc_html__( 'TikTok','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-pinterest',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Pinterest','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-instagram',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Instagram','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-youtube',
                            'type'     => 'text',
                            'title'    => esc_html__( 'You Tube','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-vimeo',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Vimeo','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tumblr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Tumblr','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-500',
                            'type'     => 'text',
                            'title'    => esc_html__( '500px','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-flickr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Flickr','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-linkedin',
                            'type'     => 'text',
                            'title'    => esc_html__( 'LinkedIn','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-foursquare',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Foursquare','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-dribbble',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Dribbble','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-skype',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Skype','arstad'),
                            'subtitle' => esc_html__( 'Enter skype URL','arstad'),
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-stumbleupon',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Stumbleupon','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-github',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Github','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-soundcloud',
                            'type'     => 'text',
                            'title'    => esc_html__( 'SoundCloud','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-spotify',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Spotify','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-buymeacoffee',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Buy Me a Coffee','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-xing',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Xing','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-whatsapp',
                            'type'     => 'text',
                            'title'    => esc_html__( 'WhatsApp','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-vk',
                            'type'     => 'text',
                            'title'    => esc_html__( 'VK','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-snapchat',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Snapchat','arstad'),
                            'subtitle' => esc_html__( 'Enter full URL','arstad'),
                            'validate' => 'url',
                        ),
                    )
					// section end
    ) );
	// social networks THE END	
	
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );


    /*
     * <--- END SECTIONS
     */
