<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "dannci_redux";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme admin panel', 'nordkapp' ),
        'page_title'           => __( 'Theme admin panel', 'nordkapp' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => true,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    

    $args['admin_bar_links'][] = array(
        'href'   => 'https://www.elegantthemes.com/affiliates/idevaffiliate.php?id=2316',
        'target'   => '_blank',
        'title' => esc_html__( 'Get PRO with Divi', 'nordkapp' ),
    );
    $args['admin_bar_links'][] = array(
        'href'   => 'http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979',
        'target'   => '_blank',
        'title' => esc_html__( 'Fast and reliable hosting', 'nordkapp' ),
    );
    $args['admin_bar_links'][] = array(
                    'href'   => 'http://dannci.com/docs',
					'target'   => '_blank',
                    'title' => esc_html__( 'Documentation', 'nordkapp' ),
    );

    // Add content after the form.
    $args['footer_text'] = __( '<p>I recommend <a href="http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979" target="_blank">DreamHost for hosting</a> your WordPress website. <a href="#">Get PRO with DIVI</a></p>', '' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    // -> START Fields
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'General Settings','nordkapp' ),
                    'desc'   => esc_html__( '','nordkapp' ),
                    'icon'   => 'el el-cogs',
                    'fields' => array( // header end
					

                        array(
                            'id'       => 'dnnc-main-logo',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo','nordkapp' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','nordkapp' ),
                        ),		
						
						array(
                            'id'       => 'dnnc-blog-layout',
                            'type'     => 'radio',
                            'title'    => esc_html__('Blog Layout','nordkapp'),
                            'subtitle' => esc_html__('Select layout and styling for the blog template','nordkapp'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'dnnc_blogger_sidebar' => esc_html__('With Sidebar','nordkapp'),
                                'dnnc_blogger_full_width' => esc_html__('Without Sidebar','nordkapp'),
                            ),
                            'default'  => 'dnnc_blogger_sidebar'
                        ),
						
												
                      	array(
                            'id'       => 'dnnc-uppercase',
                            'type'     => 'radio',
                            'title'    => esc_html__('Uppercase Fonts','nordkapp'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'upper_none' => esc_html__('None','nordkapp'),
                                'upper' => esc_html__('Minimal','nordkapp'),
                                'upper upper_medium' => esc_html__('Medium','nordkapp'),
                            ),
                            'default'  => 'upper'
                        ),
						
						
                    )
					
					// section end
    ) );
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Primary Styling','nordkapp' ),
                    'desc'   => esc_html__( '','nordkapp' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end



						array(
                            'id'          => 'nordkapp-body-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Typography','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
							'all_styles'  => true,
                            'output'      => array( 'body,input,button,select,textarea,#wpmem_reg fieldset,#wpmem_login fieldset' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as the general text.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#747677',
                                'font-style'  => '400',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '17px',
                            ),
                        ),

                        array(
                            'id'       => 'nordkapp-background',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Main Body Background','nordkapp' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','nordkapp' ),
							'transparent' => false,
                            'output'   => array('body,.dnnc_blogger .item_inn' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),
						
						array(
							'id'        => 'nordkapp-color-dnnc_ghost',
							'type'      => 'color',
							'title'     => esc_html__('Ghost Background Color','nordkapp'),
							'subtitle'  => esc_html__('Pick an alternative background color (similar to Main Body Background)','nordkapp'),
							'transparent' => false,
							'default'   => '#f9f9f9',
							'output'    => array(
								'background-color' => '.dnnc_ghost,.single .give-goal-progress,.sidebar_item,#comments .navigation a,a.page-numbers,.page-numbers.dots'
							)
						),

                        array(
                            'id'       => 'nordkapp-link-color',
                            'type'     => 'link_color',
                            'title'    => esc_html__( 'Links Color Option','nordkapp' ),
                            'subtitle' => esc_html__( 'Pick a link color','nordkapp' ),
							'output'   => array( 'a' ),
                            'default'  => array(
                                'regular' => '#000',
                                'hover'   => '#ff5745',
                                'active'  => '#000',
                            )
                        ),
						

						
						array(
							'id'        => 'nordkapp-color-entry-link',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts)','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_entry p a,.dnnc_entry ol a,.dnnc_entry ul a,.elementor-text-editor a',
							)
						),
						

						
						array(
							'id'        => 'nordkapp-color-entry-link-hover',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts): Hover Background Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','nordkapp'),
							'transparent' => false,
							'default'   => '#555',
							'output'    => array(
								'background-color' => '.dnnc_entry p a:hover,.dnnc_entry li a:hover',
							)
						),
						
                        array(
                            'id'       => 'nordkapp-primary-border',
							'type'      => 'color',
							'title'     => esc_html__('Borders Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for primary borders','nordkapp'),
							'transparent' => false,
							'default'   => '#ededed',
							'output'    => array(
								'border-color' => '.dnnc_border,.event_header p,input, textarea,select,.sidebar_item li,.comment-body,.tagcloud a,.page-numbers,.nav_item a,.dnnc_tags a',
							)
						),
						
						array(
							'id'        => 'nordkapp-text-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Text Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for sidebar text.','nordkapp'),
							'transparent' => false,
							'default'   => '#939597',
							'output'    => array(
								'color' => '#sidebar,.post-pagination span',
							)
						),
						
						array(
							'id'        => 'nordkapp-links-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','nordkapp'),
							'transparent' => false,
							'default'   => '#000000',
							'output'    => array(
								'color' => '.widgetable a',
							)
						),
						
						array(
							'id'        => 'nordkapp-links-sidebar-hover',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link: Hover Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','nordkapp'),
							'transparent' => false,
							'default'   => '#666',
							'output'    => array(
								'color' => '.widgetable a:hover',
							)
						),
                    )

					// section end
    ) );
	// Primary styling THE END
	
	
	
	
	
	
	// HEADER STYLING
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Header Styling','nordkapp' ),
                    'desc'   => esc_html__( '','nordkapp' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
										
                      	array(
                            'id'       => 'dnnc-header-layout',
                            'type'     => 'radio',
                            'title'    => esc_html__('Header Layout','nordkapp'),
                            'subtitle' => esc_html__('Select layout for your header','nordkapp'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'header_default' => esc_html__('Default Header','nordkapp'),
                                'header_fullwidth' => esc_html__('Full Width Header','nordkapp'),
                            ),
                            'default'  => 'header_fullwidth'
                        ),
						
                        array(
                            'id'       => 'dnnc-header-tranparent',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Transparent Header','nordkapp' ),
                            'default'  => '0'// 1 = on | 0 = off
                        ),

                        array(
                            'id'       => 'nordkapp-bg-header',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Header: Background','nordkapp' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','nordkapp' ),
							'transparent' => false,
                            'output'   => array('#header,.header_transparent .dnnc_page_header_plain,.header_transparent .dnnc_page_header_plain::after' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),


						array(
                            'id'          => 'nordkapp-site-title',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Site Title','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1.logo,h1.logo a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
						
						array(
							'id'        => 'nordkapp-link-title',
							'type'      => 'color',
							'title'     => esc_html__('Title Link Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for header links.','nordkapp'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'color' => '.header_transparent .dnnc_page_header_plain h1,.header_transparent .dnnc_page_header_plain .crumb a',
							)
						),

						array(
                            'id'          => 'nordkapp-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Navigation Typography','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav>li>a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#2d2d2d',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '15px',
                            ),
                        ),
						
						array(
							'id'        => 'nordkapp-hover-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Navigation Links: Hover Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a hover color for header links.','nordkapp'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'border-color' => '.nav li.current-menu-item>a,.nav >li>a:hover,#main-nav li.current-menu-ancestor>a',
							)
						),
						
						array(
							'id'        => 'nordkapdnnc_borders-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Header Borders Color','nordkapp'),
							'transparent' => false,
							'default'   => '#eee',
							'output'    => array(
								'border-color' => '#header.dnnc_border',
							)
						),
						

					
						array(
							'id'   => 'info_submenu',
							'type' => 'info',
							'title' => esc_html__('Sub-menu + Special menu button','nordkapp'),
							'style' => 'success',
						),
						
						
						
						array(
							'id'        => 'nordkapp-sub-bg-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Sub-menu Background Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for header text.','nordkapp'),
							'transparent' => false,
							'default'   => '#ffc21c',
							'output'    => array(
								'background-color' => '.nav li ul',
								'border-left-color' => '.nav>li>ul:after,.nav > li.mega:hover::after',
								'border-right-color' => 'body.rtl .nav>li>ul:after,body.rtl .nav > li.mega:hover::after',
							)
						),


						array(
                            'id'          => 'nordkapp-sub-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Sub-menu Typography','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav ul li>a,.dnnc_tagline' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '400',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						

						
						
						array(
							'id'        => 'nordkapp-special-bg',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Background Color','nordkapp'),
							'transparent' => false,
							'default'   => '#ffc21c',
							'output'    => array(
								'background-color' => '#main-nav>li.special>a',
							)
						),
						
						array(
							'id'        => 'nordkapp-special-bg-hover',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Hover Background Color','nordkapp'),
							'transparent' => false,
							'default'   => '#939597',
							'output'    => array(
								'background-color' => '#main-nav>li.special>a:hover',
							)
						),
						
						
						array(
							'id'        => 'nordkapp-special-text',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Text Color','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '#main-nav>li.special>a,#main-nav>li.special>a:hover i',
							)
						),
						
						
						array(
							'id'        => 'nordkapp-special-icon',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Icon Color','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '#main-nav>li.special>a i',
							)
						),


						array(
							'id'   => 'info_spacing',
							'type' => 'info',
							'title' => esc_html__('Spacing of the Header','nordkapp'),
							'style' => 'success',
						),

                        array(
                            'id'             => 'nordkapp-width-header',
                            'type'           => 'dimensions',
                            'output'   => array( '#titles' ),
                            'units'          => 'px', 
                            'units_extended' => 'true',  
                            'height'          => false, 
                            'title'          => esc_html__( 'Header Title/Logo Width Option','nordkapp' ),
                            'subtitle'       => esc_html__( 'Choose the width limitation for the header logo.','nordkapp' ),
                            'default'        => array(
                                'width'  => '180px',
                            )
                        ),

                        array(
                            'id'       => 'nordkapp-spacing-header',
                            'type'     => 'spacing',
                            'output'   => array( '#titles .logo' ),
                            'mode'     => 'margin',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Title/Logo Spacing','nordkapp' ),
                            'subtitle' => esc_html__( 'Choose the margin for the header logo.','nordkapp' ),
                            'default'  => array(
                                'margin-top'    => '40px',
                                'margin-bottom' => '38px',
                            )
                        ),
						

                        array(
                            'id'       => 'nordkapp-spacing-nav',
                            'type'     => 'spacing',
                            'output'   => array( '#navigation>ul' ),
                            'mode'     => 'padding',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Navigation Spacing','nordkapp' ),
                            'subtitle' => esc_html__( 'Choose the margin for header navigation.','nordkapp' ),
                            'default'  => array(
                                'padding-top'    => '34px',
                                'padding-bottom' => '31px',
                            )
                        ),

                    )
					// section end
    ) );
	// header styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Footer Styling','nordkapp' ),
                    'desc'   => esc_html__( '','nordkapp' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
						array(
							'id'        => 'nordkapp-color-myfooter',
							'type'      => 'background',
							'title'     => esc_html__('Footer: Background Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a background color for the footer.','nordkapp'),
							'transparent' => false,
                            'output'   => array('#footer,#footer .searchform input.s,.footop-right,.dnnc_bck_lnk' ),
                            'default'     => array(
                                'background-color'       => '#1e1e1e',
                            ),
						),
						
						array(
							'id'        => 'nordkapp-text-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Text: Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for footer links.','nordkapp'),
							'transparent' => false,
							'default'   => '#919191',
							'output'    => array(
								'color' => '#footer p,#footer,#footer h4,#footer .bottom-menu a,.dnnc_bck_lnk,.dnnc_bck_lnk a',
							)
						),
						
						array(
							'id'        => 'nordkapp-links-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for footer links.','nordkapp'),
							'transparent' => false,
							'default'   => '#d6d6d6',
							'output'    => array(
								'color' => '#footer a,#footer a span,#footer h2,#footer h3,#footer .meta,#footer .meta a,#footer .searchform input.s,.footop ul.social-menu li span',
							)
						),
						
						array(
							'id'        => 'nordkapp-hover-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Hover Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a hover color for footer links.','nordkapp'),
							'transparent' => false,
							'default'   => '#ffc21c',
							'output'    => array(
								'color' => '#footer a:hover,#footer a:hover span',
							)
						),
						
						
                        array(
                            'id'       => 'nordkapp-footer-border',
							'type'      => 'color',
							'title'     => esc_html__('Footer: Borders','nordkapp'),
							'subtitle'  => esc_html__('Pick a color for footer borders.','nordkapp'),
							'transparent' => false,
							'default'   => '#333333',
							'output'    => array(
								'border-color' => '#footer .dnnc_border,.dnnc_bck_lnk,.dnnc_foocol li,#footer a,#footer .dnnc_social_icons li a,#footer .searchform input.s,#footer input',
							)
						), 
						
						array(
							'id'   => 'info_special_footer',
							'type' => 'info',
							'title' => esc_html__('Special Footer Section (above the footer)','nordkapp'),
							'style' => 'success',
						),	
						
						
						array(
							'id'        => 'nordkapp-bg-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Background Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a background color for Special Footer.','nordkapp'),
							'transparent' => false,
							'default'   => '#ffc21c',
							'output'    => array(
								'background-color' => '.footop,.dnnc_social_icons li a:hover',
							)
						),
						
						
						array(
							'id'        => 'nordkapp-text-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Text / links Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a text color for Special Footer.','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '#footop h2,.footop-left a,#foo-spec,#footer .dnnc_social_icons li a:hover,#footer .dnnc_social_icons li a:hover span',
							)
						),


			
						array(
                            'id'       => 'dnnc-footer-editor',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Text','nordkapp' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','nordkapp' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','nordkapp' ),
							'default'  => '',
                            'validate' => 'html',
						),
						
						array(
                            'id'       => 'dnnc-footer-credits',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Credits Text','nordkapp' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','nordkapp' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','nordkapp' ),
							'default'  => 'Copyright © 2021 - Nordkapp Theme',
                            'validate' => 'html',
						),
                    )

					// section end
    ) );
	// footer styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(                    
					'title'  => esc_html__( 'Typography','nordkapp' ),
                    'desc'   => esc_html__( '','nordkapp' ),
                    'icon'   => 'el el-bold',
                    'fields' => array( // header end
						
						
						array(
							'id'   => 'info_titles',
							'type' => 'info',
							'title' => esc_html__('Titles','nordkapp'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'nordkapp-large',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Large Titles','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.large_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '700',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '55px',
                            ),
                        ),


						array(
                            'id'          => 'nordkapp-medium',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Medium Titles','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.medium_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),


						array(
                            'id'          => 'nordkapp-small',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Small Titles','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.small_title,.post_nav_text,.tptn_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),
						
						


						array(
                            'id'          => 'nordkapp-buttons',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Buttons Typography','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#submit,.dnnc_social_icons li a span,.mainbutton' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						
						
						
						array(
							'id'   => 'info_headings',
							'type' => 'info',
							'title' => esc_html__('Basic (in post) Headings','nordkapp'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'nordkapp-h1',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H1 Font Style','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H1.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '46px',
                            ),
                        ),
						
						array(
                            'id'          => 'nordkapp-h2',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H2 Font Style','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h2,blockquote' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H2.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '36px',
                            ),
                        ),
						
						array(
                            'id'          => 'nordkapp-h3',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H3 Font Style','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h3' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H3.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '32px',
                            ),
                        ),
						
						array(
                            'id'          => 'nordkapp-h4',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H4 Font Style','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h4' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H4.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),
						
						array(
                            'id'          => 'nordkapp-h5',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H5 Font Style','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h5,h6' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H5.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
                    )

					// section end
    ) );
	// typography styling THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Other Styling','nordkapp' ),
                    'desc'   => esc_html__( '','nordkapp' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
	
						
						array(
                            'id'          => 'nordkapp-meta',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Meta Sections: Font Style','nordkapp' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.dnnc_meta,.crumb,.post_nav_text span,.dnnc_tags a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for meta sections.','nordkapp' ),
                            'default'     => array(
                                'color'       => '#939597',
                                'font-weight'  => '500',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '12px',
                            ),
                        ),
						
						array(
							'id'        => 'nordkapp-meta-links',
							'type'      => 'color',
							'title'     => esc_html__('Meta Sections: Links Color','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_meta a'
								
							)
						),
						
						array(
							'id'        => 'nordkapp-color-dividers',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Background','nordkapp'),
							'transparent' => false,
							'default'   => '#ffc21c',
							'output'    => array(
								'background-color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs',
								'color' => '.main-breadcrumbs span::after'
								
							)
						),
						
						array(
							'id'        => 'nordkapp-color-dividers-text',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Text','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs,.dnnc_meta_categs a',
								
							)
						),
						
						array(
							'id'        => 'nordkapp-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','nordkapp'),
							'transparent' => false,
							'default'   => '#ffc21c',
							'output'    => array(
								'background-color' => '.ribbon,a.mainbutton,.cat_nr,#respond #submit,.page-numbers.current,#submit,input[type="submit"],input.button,button.submit,#comments .navigation a,.reply a,.post_pagination_inn',
								'border-color' => 'input.button,button.submit,.page-link>span',
								
							)
						),
						
						array(
							'id'        => 'nordkapp-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.ribbon,.ribbon a,a.ribbon,.ribbon p,#footer .ribbon,a.mainbutton,.cat_nr,.page-numbers.current,.format-quote blockquote,.reply a,#respond #submit,input[type="submit"],.post_pagination p a span',
							)
						),
						
						array(
							'id'        => 'nordkapp-hover-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Hover Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','nordkapp'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'background-color' => 'a.searchSubmit:hover,.ribbon:hover,a.mainbutton:hover,.meta_more a:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,h4.widget>span:after,.post_pagination p a:hover span,.owl-nav>div:hover',
								'border-color' => 'input.button:hover,button.submit:hover,.dnnc_tags a:hover'
							)
						),
						
						array(
							'id'        => 'nordkapp-hover-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Hover Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','nordkapp'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '#footer a.mainbutton:hover,.ribbon:hover,.ribbon:hover a,.ribbon a:hover,.ribbon:hover p,.entry a.ribbon:hover,a.mainbutton:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,.post_pagination p a:hover span,.owl-nav>div:hover',
							)
						),
						
						
						array(
							'id'        => 'nordkapp-images-bg',
							'type'      => 'color',
							'title'     => esc_html__('Images Background Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom background color for images.','nordkapp'),
							'transparent' => false,
							'default'   => '#1E1E1E',
							'output'    => array(
								'background-color' => '.imgwrap,.dnnc_page_header_image,.post_nav_image',
							)
						),
						
						
						
						array(
							'id'        => 'nordkapp-images-text',
							'type'      => 'color',
							'title'     => esc_html__('Images Text/Link Color','nordkapp'),
							'subtitle'  => esc_html__('Pick a custom text color for image texts (overlay)','nordkapp'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '.dnnc_page_header_image,.dnnc_page_header_image p,.dnnc_page_header_image a,.dnnc_page_header_image h1,.post_nav_image .arrow',
							)
						),
                    )
					// section end
    ) );
	// other styling THE END
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
	//POST SETTINGS
    Redux::setSection( $opt_name, array(
                   'title'  => esc_html__( 'Post Settings','nordkapp' ),
                    'desc'   => esc_html__( '','nordkapp' ),
                    'icon'   => 'el el-edit',
                    'fields' => array( // header end

						
                        array(
                            'id'       => 'dnnc-post-meta-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Disable "Meta" sections','nordkapp' ),
                            'subtitle' => esc_html__( 'Tick to disable post "information" - date, category, etc. below post titles','nordkapp' ),
                            'desc'     => esc_html__( '','nordkapp' ),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-author-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Author Box','nordkapp' ),
                            'desc'     => esc_html__( '','nordkapp' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-tags-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Tags Section','nordkapp' ),
                            'desc'     => esc_html__( '','nordkapp' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-related-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Related Post Section','nordkapp' ),
                            'desc'     => esc_html__( '','nordkapp' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
                    )
					// section end
    ) );
	// post settings THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Social Networks','nordkapp'),
                    'icon'   => 'el el-share',
                    'fields' => array( // header end
				
					

                        array(
                            'id'       => 'dnnc-social-rss',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Rss Feed','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
                        array(
                            'id'       => 'dnnc-social-facebook',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Facebook','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-twitter',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Twitter','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tiktok',
                            'type'     => 'text',
                            'title'    => esc_html__( 'TikTok','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-pinterest',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Pinterest','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-instagram',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Instagram','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-youtube',
                            'type'     => 'text',
                            'title'    => esc_html__( 'You Tube','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-vimeo',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Vimeo','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tumblr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Tumblr','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-500',
                            'type'     => 'text',
                            'title'    => esc_html__( '500px','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-flickr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Flickr','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-linkedin',
                            'type'     => 'text',
                            'title'    => esc_html__( 'LinkedIn','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-foursquare',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Foursquare','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-dribbble',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Dribbble','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-skype',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Skype','nordkapp'),
                            'subtitle' => esc_html__( 'Enter skype URL','nordkapp'),
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-stumbleupon',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Stumbleupon','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-github',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Github','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-soundcloud',
                            'type'     => 'text',
                            'title'    => esc_html__( 'SoundCloud','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-spotify',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Spotify','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-buymeacoffee',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Buy Me a Coffee','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-xing',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Xing','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-whatsapp',
                            'type'     => 'text',
                            'title'    => esc_html__( 'WhatsApp','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-vk',
                            'type'     => 'text',
                            'title'    => esc_html__( 'VK','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-snapchat',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Snapchat','nordkapp'),
                            'subtitle' => esc_html__( 'Enter full URL','nordkapp'),
                            'validate' => 'url',
                        ),
                    )
					// section end
    ) );
	// social networks THE END	
	
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );


    /*
     * <--- END SECTIONS
     */
