<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "dannci_redux";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme admin panel', 'nurmes' ),
        'page_title'           => __( 'Theme admin panel', 'nurmes' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => true,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    

    $args['admin_bar_links'][] = array(
        'href'   => 'https://www.elegantthemes.com/affiliates/idevaffiliate.php?id=2316',
        'target'   => '_blank',
        'title' => esc_html__( 'Get PRO with Divi', 'nurmes' ),
    );
    $args['admin_bar_links'][] = array(
        'href'   => 'http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979',
        'target'   => '_blank',
        'title' => esc_html__( 'Fast and reliable hosting', 'nurmes' ),
    );
    $args['admin_bar_links'][] = array(
                    'href'   => 'http://dannci.com/docs',
					'target'   => '_blank',
                    'title' => esc_html__( 'Documentation', 'nurmes' ),
    );

    // Add content after the form.
    $args['footer_text'] = __( '<p>I recommend <a href="http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979" target="_blank">DreamHost for hosting</a> your WordPress website. <a href="#">Get PRO with DIVI</a></p>', '' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    // -> START Fields
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'General Settings','nurmes' ),
                    'desc'   => esc_html__( '','nurmes' ),
                    'icon'   => 'el el-cogs',
                    'fields' => array( // header end
					

                        array(
                            'id'       => 'dnnc-main-logo',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo','nurmes' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','nurmes' ),
                        ),		                        
                        
                        array(
                            'id'       => 'dnnc-main-logo-inv',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo for Transparent Header','nurmes' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','nurmes' ),
                        ),
						
						array(
                            'id'       => 'dnnc-blog-layout',
                            'type'     => 'radio',
                            'title'    => esc_html__('Blog Layout','nurmes'),
                            'subtitle' => esc_html__('Select layout and styling for the blog template','nurmes'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'dnnc_blogger_sidebar' => esc_html__('With Sidebar','nurmes'),
                                'dnnc_blogger_full_width' => esc_html__('Without Sidebar','nurmes'),
                            ),
                            'default'  => 'dnnc_blogger_sidebar'
                        ),



                        
						
						
                        array(
                            'id'       => 'tmnf-slider-dis',
                            'type'     => 'checkbox',
                            'title'    => __( 'Enable Homepage Slider','nurmes'),
                            'subtitle' => __( 'You can enable slider here.','nurmes'),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						 array(
							'id' => 'tmnf-slider-cats',
							'type' => 'select',
							'data' => 'categories',
							'multi' => true,
							'title' => esc_html__('Homepage Slider: Featured categories (required)','nurmes'),
							'subtitle' => esc_html__('','nurmes'),
							'desc' => esc_html__('','nurmes'),
							'default'  => ''
						),
						
						 array(
							'id' => 'tmnf-slider-nr',
							'type' => 'select',
							'title' => esc_html__('Homepage Slider: Number of posts','nurmes'),
							'subtitle' => esc_html__('','nurmes'),
							'desc' => __('','nurmes'),
							'options'  => array(
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                                '9' => '9',
                                '10' => '10',
							),
							'default'  => '4'
						),
						
						
												
                      	array(
                            'id'       => 'dnnc-uppercase',
                            'type'     => 'radio',
                            'title'    => esc_html__('Uppercase Fonts','nurmes'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'upper_none' => esc_html__('None','nurmes'),
                                'upper' => esc_html__('Minimal','nurmes'),
                                'upper upper_medium' => esc_html__('Medium','nurmes'),
                                'upper upper_medium upper_maxi' => esc_html__('Maxi','nurmes'),
                            ),
                            'default'  => 'upper'
                        ),
						
						
                    )
					
					// section end
    ) );
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Primary Styling','nurmes' ),
                    'desc'   => esc_html__( '','nurmes' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end



						array(
                            'id'          => 'nurmes-body-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Typography','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
							'all_styles'  => true,
                            'output'      => array( 'body,input,button,select,textarea,#wpmem_reg fieldset,#wpmem_login fieldset,.dnnc_blogger .item_inn' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as the general text.','nurmes' ),
                            'default'     => array(
                                'color'       => '#222',
                                'font-style'  => '400',
                                'font-family' => 'Lora',
                                'google'      => true,
                                'font-size'   => '18px',
                            ),
                        ),

                        array(
                            'id'       => 'nurmes-background',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Main Body Background','nurmes' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','nurmes' ),
							'transparent' => false,
                            'output'   => array('body,.dnnc_blogger .item_inn' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),
						
						array(
							'id'        => 'nurmes-color-dnnc_ghost',
							'type'      => 'color',
							'title'     => esc_html__('Ghost Background Color','nurmes'),
							'subtitle'  => esc_html__('Pick an alternative background color (similar to Main Body Background)','nurmes'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'background-color' => '.dnnc_ghost,.single .give-goal-progress,.sidebar_item,#comments .navigation a,a.page-numbers,.page-numbers.dots'
							)
						),

                        array(
                            'id'       => 'nurmes-link-color',
                            'type'     => 'link_color',
                            'title'    => esc_html__( 'Links Color Option','nurmes' ),
                            'subtitle' => esc_html__( 'Pick a link color','nurmes' ),
							'output'   => array( 'a' ),
                            'default'  => array(
                                'regular' => '#000',
                                'hover'   => '#ff5745',
                                'active'  => '#000',
                            )
                        ),
						

						
						array(
							'id'        => 'nurmes-color-entry-link',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts)','nurmes'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','nurmes'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_entry p a,.dnnc_entry ol a,.dnnc_entry ul a,.elementor-text-editor a',
							)
						),
						

						
						array(
							'id'        => 'nurmes-color-entry-link-hover',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts): Hover Background Color','nurmes'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','nurmes'),
							'transparent' => false,
							'default'   => '#555',
							'output'    => array(
								'background-color' => '.dnnc_entry p a:hover,.dnnc_entry li a:hover',
							)
						),
						
                        array(
                            'id'       => 'nurmes-primary-border',
							'type'      => 'color',
							'title'     => esc_html__('Borders Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for primary borders','nurmes'),
							'transparent' => false,
							'default'   => '#ededed',
							'output'    => array(
								'border-color' => '.dnnc_border,.sidebar_item,.event_header p,input, textarea,select,.sidebar_item li,.comment-body,.tagcloud a,.page-numbers,.nav_item a,.dnnc_tags a',
							)
						),
						
						array(
							'id'        => 'nurmes-text-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Text Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for sidebar text.','nurmes'),
							'transparent' => false,
							'default'   => '#939597',
							'output'    => array(
								'color' => '#sidebar,.post-pagination span',
							)
						),
						
						array(
							'id'        => 'nurmes-links-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','nurmes'),
							'transparent' => false,
							'default'   => '#000000',
							'output'    => array(
								'color' => '.widgetable a',
							)
						),
						
						array(
							'id'        => 'nurmes-links-sidebar-hover',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link: Hover Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','nurmes'),
							'transparent' => false,
							'default'   => '#666',
							'output'    => array(
								'color' => '.widgetable a:hover',
							)
						),
                    )

					// section end
    ) );
	// Primary styling THE END
	
	
	
	
	
	
	// HEADER STYLING
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Header Styling','nurmes' ),
                    'desc'   => esc_html__( '','nurmes' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
										
                      	array(
                            'id'       => 'dnnc-header-layout',
                            'type'     => 'radio',
                            'title'    => esc_html__('Header Layout','nurmes'),
                            'subtitle' => esc_html__('Select layout for your header','nurmes'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'header_default' => esc_html__('Default Header','nurmes'),
                                'header_fullwidth' => esc_html__('Full Width Header','nurmes'),
                            ),
                            'default'  => 'header_fullwidth'
                        ),

                        array(
                            'id'       => 'nurmes-bg-header',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Header: Background','nurmes' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','nurmes' ),
							'transparent' => false,
                            'output'   => array('#header,.dnnc_slider_wrap' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),


						array(
                            'id'          => 'nurmes-site-title',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Site Title','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#titles h1,#titles h1 a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','nurmes' ),
                            'default'     => array(
                                'color'       => '#3a3a3a',
                                'font-weight'  => '700',
                                'font-family' => 'Karla',
                                'google'      => true,
                                'font-size'   => '18px',
                            ),
                        ),
						
						array(
							'id'        => 'nurmes-link-title',
							'type'      => 'color',
							'title'     => esc_html__('Title Link Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for header links.','nurmes'),
							'transparent' => false,
							'default'   => '#3a3a3a',
							'output'    => array(
								'color' => '.dnnc_slider_wrap a',
							)
						),

						array(
                            'id'          => 'nurmes-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Navigation Typography','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav>li>a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','nurmes' ),
                            'default'     => array(
                                'color'       => '#3a3a3a',
                                'font-weight'  => '600',
                                'font-family' => 'Karla',
                                'google'      => true,
                                'font-size'   => '15px',
                            ),
                        ),
						
						array(
							'id'        => 'nurmes-hover-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Navigation Links: Hover Color','nurmes'),
							'subtitle'  => esc_html__('Pick a hover color for header links.','nurmes'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'border-color' => '.nav > li.current-menu-item>a,.nav >li>a:hover,.nav li.current-menu-ancestor>a',
							)
						),
						
						array(
							'id'        => 'nordkapdnnc_borders-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Header Borders Color','nurmes'),
							'transparent' => false,
							'default'   => '#eee',
							'output'    => array(
								'border-color' => '#header.dnnc_border',
							)
						),
						

					
						array(
							'id'   => 'info_submenu',
							'type' => 'info',
							'title' => esc_html__('Sub-menu + Special menu button','nurmes'),
							'style' => 'success',
						),
						
						
						
						array(
							'id'        => 'nurmes-sub-bg-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Sub-menu Background Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for header text.','nurmes'),
							'transparent' => false,
							'default'   => '#ff7760',
							'output'    => array(
								'background-color' => '.nav li ul',
								'border-left-color' => '.nav>li>ul:after,.nav > li.mega:hover::after',
								'border-right-color' => 'body.rtl .nav>li>ul:after,body.rtl .nav > li.mega:hover::after',
							)
						),


						array(
                            'id'          => 'nurmes-sub-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Sub-menu Typography','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav ul li>a,.dnnc_tagline' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','nurmes' ),
                            'default'     => array(
                                'color'       => '#fff',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '17px',
                            ),
                        ),
						

						
						
						array(
							'id'        => 'nurmes-special-bg',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Background Color','nurmes'),
							'transparent' => false,
							'default'   => '#ff7760',
							'output'    => array(
								'background-color' => '.nav>li.special>a,.owl-nav>div,#header .dnnc_social_icons li a',
                                
							)
						),
						
						array(
							'id'        => 'nurmes-special-bg-hover',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Hover Background Color','nurmes'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'background-color' => '.nav>li.special>a:hover,.owl-nav>div:hover:hover,#header .dnnc_social_icons li a:hover',
							)
						),
						
						
						array(
							'id'        => 'nurmes-special-text',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Text Color','nurmes'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '.nav>li.special>a,.nav>li.special>a:hover i,.owl-nav>div,#header .dnnc_social_icons li a',
							)
						),
						
						
						array(
							'id'        => 'nurmes-special-icon',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Icon Color','nurmes'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '.nav>li.special>a i',
							)
						),

						array(
							'id'   => 'tmnf-info-trans',
							'type' => 'info',
							'title' => esc_html__('Transparent Header','nurmes'),
							'style' => 'success',
						),
						
						
						array(
							'id'        => 'nurmes-images-bg',
							'type'      => 'color',
							'title'     => esc_html__('Transparent Header: Background Color (fallback)','nurmes'),
							'transparent' => false,
							'default'   => '#1E1E1E',
							'output'    => array(
								'background-color' => '[class*="hero-cover"]  #header,.imgwrap,.dnnc_page_header_image,.post_nav_image,.tmnf_respo_magic #navigation',
                                'color' => '[class*="hero-cover"] #header .dnnc_social_icons li a',
                                )
						),
						
						
						
						array(
							'id'        => 'nurmes-images-text',
							'type'      => 'color',
							'title'     => esc_html__('Transparent Header: Text Color','nurmes'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '[class*="hero-cover"] #titles h1 a,[class*="hero-cover"]  #header .nav > li > a,.dnnc_page_header_image,.dnnc_page_header_image p,.dnnc_page_header_image a,.dnnc_page_header_image h1,.dnnc_page_header_image .dnnc_meta a,.post_nav_image .arrow,.tmnf_respo_magic #navigation li:not(.special) a',
                                'background-color' => '[class*="hero-cover"] #header .dnnc_social_icons li a',
                            )
						),



						array(
							'id'   => 'info_spacing',
							'type' => 'info',
							'title' => esc_html__('Spacing of the Header','nurmes'),
							'style' => 'success',
						),

                        array(
                            'id'             => 'nurmes-width-header',
                            'type'           => 'dimensions',
                            'output'   => array( '#titles' ),
                            'units'          => 'px', 
                            'units_extended' => 'true',  
                            'height'          => false, 
                            'title'          => esc_html__( 'Header Title/Logo Width Option','nurmes' ),
                            'subtitle'       => esc_html__( 'Choose the width limitation for the header logo.','nurmes' ),
                            'default'        => array(
                                'width'  => '180px',
                            )
                        ),

                        array(
                            'id'       => 'nurmes-spacing-header',
                            'type'     => 'spacing',
                            'output'   => array( '#titles' ),
                            'mode'     => 'margin',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Title/Logo Spacing','nurmes' ),
                            'subtitle' => esc_html__( 'Choose the margin for the header logo.','nurmes' ),
                            'default'  => array(
                                'margin-top'    => '40px',
                                'margin-bottom' => '38px',
                            )
                        ),
						

                        array(
                            'id'       => 'nurmes-spacing-nav',
                            'type'     => 'spacing',
                            'output'   => array( '#navigation>ul,#header .dnnc_social_icons' ),
                            'mode'     => 'padding',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Navigation Spacing','nurmes' ),
                            'subtitle' => esc_html__( 'Choose the margin for header navigation.','nurmes' ),
                            'default'  => array(
                                'padding-top'    => '31px',
                                'padding-bottom' => '29px',
                            )
                        ),

                    )
					// section end
    ) );
	// header styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Footer Styling','nurmes' ),
                    'desc'   => esc_html__( '','nurmes' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
						array(
							'id'        => 'nurmes-color-myfooter',
							'type'      => 'background',
							'title'     => esc_html__('Footer: Background Color','nurmes'),
							'subtitle'  => esc_html__('Pick a background color for the footer.','nurmes'),
							'transparent' => false,
                            'output'   => array('#footer,#footer .searchform input.s,.footop-right,.dnnc_bck_lnk' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
						),
						
						array(
							'id'        => 'nurmes-text-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Text: Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for footer links.','nurmes'),
							'transparent' => false,
							'default'   => '#515151',
							'output'    => array(
								'color' => '#footer p,#footer,#footer h4,#footer .bottom-menu a,.dnnc_bck_lnk,.dnnc_bck_lnk a',
							)
						),
						
						array(
							'id'        => 'nurmes-links-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Color','nurmes'),
							'subtitle'  => esc_html__('Pick a color for footer links.','nurmes'),
							'transparent' => false,
							'default'   => '#3d3d3d',
							'output'    => array(
								'color' => '#footer a,#footer a span,#footer h2,#footer h3,#footer .meta,#footer .meta a,#footer .searchform input.s,.footop ul.social-menu li span',
							)
						),
						
						array(
							'id'        => 'nurmes-hover-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Hover Color','nurmes'),
							'subtitle'  => esc_html__('Pick a hover color for footer links.','nurmes'),
							'transparent' => false,
							'default'   => '#D73D0F',
							'output'    => array(
								'color' => '#footer a:hover,#footer a:hover span',
							)
						),
						
						
                        array(
                            'id'       => 'nurmes-footer-border',
							'type'      => 'color',
							'title'     => esc_html__('Footer: Borders','nurmes'),
							'subtitle'  => esc_html__('Pick a color for footer borders.','nurmes'),
							'transparent' => false,
							'default'   => '#efefef',
							'output'    => array(
								'border-color' => '#footer .dnnc_border,.dnnc_bck_lnk,.dnnc_foocol li,#footer a,#footer .dnnc_social_icons li a,#footer .searchform input.s,#footer input',
							)
						), 
						
						array(
							'id'   => 'info_special_footer',
							'type' => 'info',
							'title' => esc_html__('Special Footer Section (above the footer)','nurmes'),
							'style' => 'success',
						),	
						
						
						array(
							'id'        => 'nurmes-bg-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Background Color','nurmes'),
							'subtitle'  => esc_html__('Pick a background color for Special Footer.','nurmes'),
							'transparent' => false,
							'default'   => '#D73D0F',
							'output'    => array(
								'background-color' => '.footop,.dnnc_social_icons li a:hover',
							)
						),
						
						
						array(
							'id'        => 'nurmes-text-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Text / links Color','nurmes'),
							'subtitle'  => esc_html__('Pick a text color for Special Footer.','nurmes'),
							'transparent' => false,
							'default'   => '#3a3a3a',
							'output'    => array(
								'color' => '#footop h2,.footop-left a,#foo-spec,#footer .dnnc_social_icons li a:hover,#footer .dnnc_social_icons li a:hover span',
							)
						),


			
						array(
                            'id'       => 'dnnc-footer-editor',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Text','nurmes' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','nurmes' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','nurmes' ),
							'default'  => '',
                            'validate' => 'html',
						),
						
						array(
                            'id'       => 'dnnc-footer-credits',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Credits Text','nurmes' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','nurmes' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','nurmes' ),
							'default'  => 'Copyright © 2023 - Nurmes Theme',
                            'validate' => 'html',
						),
                    )

					// section end
    ) );
	// footer styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(                    
					'title'  => esc_html__( 'Typography','nurmes' ),
                    'desc'   => esc_html__( '','nurmes' ),
                    'icon'   => 'el el-bold',
                    'fields' => array( // header end
						
						
						array(
							'id'   => 'info_titles',
							'type' => 'info',
							'title' => esc_html__('Titles','nurmes'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'nurmes-large',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Large Titles','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.large_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '700',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '75px',
                            ),
                        ),


						array(
                            'id'          => 'nurmes-medium',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Medium Titles','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.medium_title,blockquote' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '40px',
                            ),
                        ),


						array(
                            'id'          => 'nurmes-small',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Small Titles','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.small_title,.post_nav_text,.tptn_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),
						
						


						array(
                            'id'          => 'nurmes-buttons',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Buttons Typography','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#submit,.dnnc_social_icons li a span,.mainbutton' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						
						
						
						array(
							'id'   => 'info_headings',
							'type' => 'info',
							'title' => esc_html__('Basic (in post) Headings','nurmes'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'nurmes-h1',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H1 Font Style','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H1.','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '46px',
                            ),
                        ),
						
						array(
                            'id'          => 'nurmes-h2',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H2 Font Style','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h2' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H2.','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '36px',
                            ),
                        ),
						
						array(
                            'id'          => 'nurmes-h3',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H3 Font Style','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h3' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H3.','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '32px',
                            ),
                        ),
						
						array(
                            'id'          => 'nurmes-h4',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H4 Font Style','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h4' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H4.','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),
						
						array(
                            'id'          => 'nurmes-h5',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H5 Font Style','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h5,h6' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H5.','nurmes' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
                    )

					// section end
    ) );
	// typography styling THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Other Styling','nurmes' ),
                    'desc'   => esc_html__( '','nurmes' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
	
						
						array(
                            'id'          => 'nurmes-meta',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Meta Sections: Font Style','nurmes' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.dnnc_meta,.crumb,.post_nav_text span,.dnnc_tags a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for meta sections.','nurmes' ),
                            'default'     => array(
                                'color'       => '#3a3a3a',
                                'font-weight'  => '500',
                                'font-family' => 'Cormorant',
                                'google'      => true,
                                'font-size'   => '10px',
                            ),
                        ),
						
						array(
							'id'        => 'nurmes-meta-links',
							'type'      => 'color',
							'title'     => esc_html__('Meta Sections: Links Color','nurmes'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_meta a'
								
							)
						),
						
						array(
							'id'        => 'nurmes-color-dividers',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Background','nurmes'),
							'transparent' => false,
							'default'   => '#9de2ea',
							'output'    => array(
								'background-color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs',
								'color' => '.main-breadcrumbs span::after'
								
							)
						),
						
						array(
							'id'        => 'nurmes-color-dividers-text',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Text','nurmes'),
							'transparent' => false,
							'default'   => '#053463',
							'output'    => array(
								'color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs,.dnnc_meta_categs a',
								
							)
						),
						
						array(
							'id'        => 'nurmes-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Color','nurmes'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','nurmes'),
							'transparent' => false,
							'default'   => '#9de2ea',
							'output'    => array(
								'background-color' => '.ribbon,a.mainbutton,.cat_nr,#respond #submit,.page-numbers.current,#submit,input[type="submit"],input.button,button.submit,#comments .navigation a,.reply a,.post_pagination_inn',
								'border-color' => 'input.button,button.submit,.page-link>span',
								
							)
						),
						
						array(
							'id'        => 'nurmes-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Color','nurmes'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','nurmes'),
							'transparent' => false,
							'default'   => '#053463',
							'output'    => array(
								'color' => '.ribbon,.ribbon a,a.ribbon,.ribbon p,#footer .ribbon,a.mainbutton,.cat_nr,.page-numbers.current,.format-quote blockquote,.reply a,#respond #submit,input[type="submit"],.post_pagination p a span',
							)
						),
						
						array(
							'id'        => 'nurmes-hover-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Hover Color','nurmes'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','nurmes'),
							'transparent' => false,
							'default'   => '#ff7760',
							'output'    => array(
								'background-color' => 'a.searchSubmit:hover,.ribbon:hover,a.mainbutton:hover,.meta_more a:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,h4.widget>span:after,.post_pagination p a:hover span',
								'border-color' => 'input.button:hover,button.submit:hover,.dnnc_tags a:hover'
							)
						),
						
						array(
							'id'        => 'nurmes-hover-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Hover Color','nurmes'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','nurmes'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '#footer a.mainbutton:hover,.ribbon:hover,.ribbon:hover a,.ribbon a:hover,.ribbon:hover p,.entry a.ribbon:hover,a.mainbutton:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,.post_pagination p a:hover span',
							)
						),
						
						

                    )
					// section end
    ) );
	// other styling THE END
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
	//POST SETTINGS
    Redux::setSection( $opt_name, array(
                   'title'  => esc_html__( 'Post Settings','nurmes' ),
                    'desc'   => esc_html__( '','nurmes' ),
                    'icon'   => 'el el-edit',
                    'fields' => array( // header end

						
                        array(
                            'id'       => 'dnnc-post-meta-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Disable "Meta" sections','nurmes' ),
                            'subtitle' => esc_html__( 'Tick to disable post "information" - date, category, etc. below post titles','nurmes' ),
                            'desc'     => esc_html__( '','nurmes' ),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-author-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Author Box','nurmes' ),
                            'desc'     => esc_html__( '','nurmes' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-tags-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Tags Section','nurmes' ),
                            'desc'     => esc_html__( '','nurmes' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-related-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Related Post Section','nurmes' ),
                            'desc'     => esc_html__( '','nurmes' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
                    )
					// section end
    ) );
	// post settings THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Social Networks','nurmes'),
                    'icon'   => 'el el-share',
                    'fields' => array( // header end
				
					

                        array(
                            'id'       => 'dnnc-social-rss',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Rss Feed','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
                        array(
                            'id'       => 'dnnc-social-facebook',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Facebook','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-twitter',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Twitter','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tiktok',
                            'type'     => 'text',
                            'title'    => esc_html__( 'TikTok','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-pinterest',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Pinterest','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-instagram',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Instagram','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-youtube',
                            'type'     => 'text',
                            'title'    => esc_html__( 'You Tube','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-vimeo',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Vimeo','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tumblr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Tumblr','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-500',
                            'type'     => 'text',
                            'title'    => esc_html__( '500px','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-flickr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Flickr','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-linkedin',
                            'type'     => 'text',
                            'title'    => esc_html__( 'LinkedIn','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-foursquare',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Foursquare','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-dribbble',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Dribbble','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-skype',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Skype','nurmes'),
                            'subtitle' => esc_html__( 'Enter skype URL','nurmes'),
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-stumbleupon',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Stumbleupon','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-github',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Github','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-soundcloud',
                            'type'     => 'text',
                            'title'    => esc_html__( 'SoundCloud','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-spotify',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Spotify','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-xing',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Xing','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-whatsapp',
                            'type'     => 'text',
                            'title'    => esc_html__( 'WhatsApp','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-vk',
                            'type'     => 'text',
                            'title'    => esc_html__( 'VK','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-snapchat',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Snapchat','nurmes'),
                            'subtitle' => esc_html__( 'Enter full URL','nurmes'),
                            'validate' => 'url',
                        ),
                    )
					// section end
    ) );
	// social networks THE END	
	
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );


    /*
     * <--- END SECTIONS
     */
