<?php

/*-----------------------------------------------------------------------------------
- Default
----------------------------------------------------------------------------------- */

add_action( 'after_setup_theme', 'skagen_theme_setup' );

function skagen_theme_setup() {
	global $content_width;

	/* Set the $content_width for things such as video embeds. */
	if ( !isset( $content_width ) )
		$content_width = 750;

	/* Add theme support for automatic feed links. */
	add_theme_support( 'post-formats', array( 'video','audio', 'gallery','quote', 'link', 'aside' ) );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'custom-background' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-logo' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'responsive-embeds' );
	
	/* Add theme support for post thumbnails (featured images). */	
	add_theme_support('post-thumbnails');
	add_image_size('skagen_blog', 612, 9999, false ); 	//(cropped)

	/* Add custom menus */
	register_nav_menus(array(
		'main-menu' => esc_html__( 'Main Menu','skagen' ),
		'bottom-menu' => esc_html__( 'Footer Menu','skagen' ),
	));

	/* Add your sidebars function to the 'widgets_init' action hook. */
	add_action( 'widgets_init', 'skagen_register_sidebars' );
	
	/* Make theme available for translation */
	load_theme_textdomain('skagen', get_template_directory() . '/lang' );

}

function skagen_register_sidebars() {
	
	register_sidebar(array('name' => esc_html__( 'Sidebar','skagen' ),'id' => 'dnnc-sidebar','description' => esc_html__( 'Sidebar widget section','skagen' ),'before_widget' => '<div class="sidebar_item">','after_widget' => '</div>','before_title' => '<h4 class="widget dnnc_border"><span>','after_title' => '</span></h4>'));

	//footer widgets
	register_sidebar(array('name' => esc_html__( 'Footer 1','skagen' ),'id' => 'dnnc-footer-1','description' => esc_html__( 'Widget section in footer - left','skagen' ),'before_widget' => '','after_widget' => '','before_title' => '<h4 class="widget dnnc_border small_title">','after_title' => '</h4>'));
	register_sidebar(array('name' => esc_html__( 'Footer 2','skagen' ),'id' => 'dnnc-footer-2','description' => esc_html__( 'Widget section in footer - center/left','skagen' ),'before_widget' => '','after_widget' => '','before_title' => '<h4 class="widget dnnc_border small_title">','after_title' => '</h4>'));
	register_sidebar(array('name' => esc_html__( 'Footer 3','skagen' ),'id' => 'dnnc-footer-3','description' => esc_html__( 'Widget section in footer - center/right','skagen' ),'before_widget' => '','after_widget' => '','before_title' => '<h4 class="widget dnnc_border small_title">','after_title' => '</h4>'));
	register_sidebar(array('name' => esc_html__( 'Footer 4','skagen' ),'id' => 'dnnc-footer-4','description' => esc_html__( 'Widget section in footer - right','skagen' ),'before_widget' => '','after_widget' => '','before_title' => '<h4 class="widget dnnc_border small_title">','after_title' => '</h4>'));
	
}

	
/*-----------------------------------------------------------------------------------
- Framework - Please refrain from editing this section 
----------------------------------------------------------------------------------- */


// Set path to Framework and theme specific functions
$functions_path = get_template_directory() . '/functions/';

// Theme specific functionality
require_once ($functions_path . 'admin-functions.php');					// Custom functions and plugins

// Add Redux options panel
if ( !isset( $dannci_redux ) && file_exists( get_template_directory()  . '/redux-framework/redux-themnific.php' ) ) {
    require_once( get_template_directory()  . '/redux-framework/redux-themnific.php' );
}

	
/*-----------------------------------------------------------------------------------
- Enqueues scripts and styles for front end
----------------------------------------------------------------------------------- */ 

function skagen_enqueue_style() {
	
	// main stylesheet
	wp_enqueue_style('skagen-style', get_stylesheet_uri());
	
	// skagen mobile stylesheet
	wp_enqueue_style('skagen-mobile', get_template_directory_uri().'/style-mobile.css');
	
	// Font Awesome css	
	wp_enqueue_style('fontawesome', get_template_directory_uri() .	'/styles/fontawesome.css');
	
}
add_action( 'wp_enqueue_scripts', 'skagen_enqueue_style' );



function skagen_enqueue_script() {	

		// Load Common scripts	
		wp_enqueue_script('skagen-ownscript', get_template_directory_uri() .'/js/ownScript.js',array( 'jquery' ),'', true);		

		// Singular comment script		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
			wp_enqueue_script( 'comment-reply' );

}
	
add_action('wp_enqueue_scripts', 'skagen_enqueue_script');


/*-----------------------------------------------------------------------------------
- Include accessible
----------------------------------------------------------------------------------- */

include_once (get_template_directory() . '/functions/aria-walker-nav-menu.php');



/*-----------------------------------------------------------------------------------
- TGM_Plugin_Activation class.
----------------------------------------------------------------------------------- */
require_once get_template_directory()  . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'skagen_register_required_plugins' );
function skagen_register_required_plugins() {

    $plugins = array(
	

        // redux-framework
        array(
            'name'				=> esc_html__( 'Redux Framework','skagen' ),
            'slug'      		=> 'redux-framework',
            'required'  		=> true,
        ),
        // top-10
        array(
            'name'				=> esc_html__( 'Top 10','skagen' ),
            'slug'      		=> 'top-10',
            'required'  		=> false,
        ), 
        // classic-widgets
        array(
            'name'				=> esc_html__( 'Classic Widgets','skagen' ),
            'slug'      		=> 'classic-widgets',
            'required'  		=> false,
        ),
        // one-click-demo-import
        array(
            'name'				=> esc_html__( 'One Click Demo Import','skagen' ),
            'slug'      		=> 'one-click-demo-import',
            'required'  		=> false,
        ),

    );
    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins','skagen' ),
            'menu_title'                      => esc_html__( 'Install Plugins','skagen' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s','skagen' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.','skagen' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.','This theme requires the following plugins: %1$s.','skagen' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.','This theme recommends the following plugins: %1$s.','skagen' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.','skagen' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.','skagen' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.','skagen' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.','skagen' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.','skagen' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.','skagen' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins','skagen' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins','skagen' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer','skagen' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.','skagen' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s','skagen' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );

    tgmpa( $plugins, $config );

}

	
/*-----------------------------------------------------------------------------------
- Other theme functions
----------------------------------------------------------------------------------- */

// icons - font awesome
if ( ! function_exists ( 'skagen_icon' ) ) {
	function skagen_icon() {
		if(has_post_format('audio')) {return '<i title="'. esc_attr__('Audio','skagen').'" class="dnnc_icon fas fa-volume-up"></i>';
		}elseif(has_post_format('gallery')) {return '<i title="'. esc_attr__('Gallery','skagen').'" class="dnnc_icon fas fa-camera"></i>';
		}elseif(has_post_format('image')) {return '<i title="'. esc_attr__('Image','skagen').'" class="dnnc_icon fas fa-camera"></i>';	
		}elseif(has_post_format('link')) {return '<i title="'. esc_attr__('Link','skagen').'" class="dnnc_icon fas fa-link"></i>';			
		}elseif(has_post_format('quote')) {return '<i title="'. esc_attr__('Quote','skagen').'" class="dnnc_icon fas fa-quote-right"></i>';		
		}elseif(has_post_format('video')) {return '<i title="'. esc_attr__('Video','skagen').'" class="dnnc_icon fas fa-play-circle"></i>';
		} 	
	}
}


// new excerpt function
// Old Shorten Excerpt text for use in theme
function skagen_excerpt($text, $chars = 1620) {
	$text = $text." ";
	$text = substr($text,0,$chars);
	$text = substr($text,0,strrpos($text,' '));
	$text = $text."";
	return $text;
}

function skagen_trim_excerpt($text) {
     $text = str_replace('[', '', $text);
     $text = str_replace(']', '', $text);
     return $text;
    }
add_filter('get_the_excerpt', 'skagen_trim_excerpt');

// excerpt class
function skagen_class_to_excerpt( $excerpt ){
    return '<div class="dnnc_excerpt">'.$excerpt.'</div>';
}
add_action('the_excerpt','skagen_class_to_excerpt');


// meta sections
if ( ! function_exists ( 'skagen_meta_cat' ) ) {
	function skagen_meta_cat() { ?>   
		<p class="dnnc_meta dnnc_meta_categs <?php foreach((get_the_category()) as $category) {      echo esc_attr($category->slug) . '_category_color ';  } ?> <?php $dannci_redux = get_option( 'dannci_redux' ); if(isset($dannci_redux['dnnc-post-meta-dis']) ? $dannci_redux['dnnc-post-meta-dis'] : null) echo 'dnnc_hide';?>">
        <span class="categs"><?php the_category(' • ') ?></span>
		</p>
	<?php }
}

if ( ! function_exists ( 'skagen_meta_front' ) ) {
	function skagen_meta_front() { ?>    
		<p class="dnnc_meta <?php $dannci_redux = get_option( 'dannci_redux' ); if(isset($dannci_redux['dnnc-post-meta-dis']) ? $dannci_redux['dnnc-post-meta-dis'] : null) echo 'dnnc_hide';?>">
			<span class="post-date"><?php the_time(get_option('date_format')); ?><span class="meta_divider">&bull;</span></span>
            <?php 
				echo '<span class="author">';
				echo '<span class="author_by">' ;
				esc_html_e('by','skagen') ;
				echo '</span>'; 
				the_author_posts_link();
				echo '</span>';	?>
		</p>
	<?php
	}
}

if ( ! function_exists ( 'skagen_meta_full' ) ) {
	function skagen_meta_full() { ?>    
		<p class="dnnc_meta dnnc_meta_full <?php $dannci_redux = get_option( 'dannci_redux' ); if(isset($dannci_redux['dnnc-post-meta-dis']) ? $dannci_redux['dnnc-post-meta-dis'] : null) echo 'dnnc_hide';?>">
			<span class="post-date"><?php the_time(get_option('date_format')); ?><span class="meta_divider">&bull;</span></span>
			<span class="categs"><?php the_category(', ') ?><span class="meta_divider">&bull;</span></span>
			<?php echo '<span class="author">'; the_author_posts_link();echo '</span>';	?>
		</p>
	<?php
	}
}

if ( ! function_exists ( 'skagen_meta_more' ) ) {
	function skagen_meta_more() { ?>   
        <p class="dnnc_meta dnnc_meta_more tranz">
            <a class="link--forsure" href="<?php the_permalink() ?>"><?php esc_html_e('Read More','skagen');?> &rarr;</a>
        </p>
	<?php }
}



// menu description
function skagen_nav_description( $item_output, $item, $depth, $args ) {
    if ( !empty( $item->description ) ) {
        $item_output = str_replace( $args->link_after . '</a>', '<span class="menu-item-description tranz">' . $item->description . '</span>' . $args->link_after . '</a>', $item_output );
    }
 
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'skagen_nav_description', 10, 4 );

//author box - additional links
if ( ! function_exists ( 'skagen_new_contactmethods' ) ) {
	function skagen_new_contactmethods( $contactmethods ) {
		$contactmethods['twitter'] = 'Twitter';
		$contactmethods['facebook'] = 'Facebook';
		$contactmethods['linkedin'] = 'LinkedIn';
		$contactmethods['pinterest'] = 'Pinterest';
		$contactmethods['instagram'] = 'Instagram';
		$contactmethods['link'] = 'Any Link';
		return $contactmethods;
	}
	add_filter('user_contactmethods','skagen_new_contactmethods',10,1);
}



// register custom fonts for Gutenberg

add_action( 'after_setup_theme', 'misha_gutenberg_css' );
 
function misha_gutenberg_css(){
 
	add_theme_support( 'editor-styles' ); 
	add_editor_style( 'styles/style-editor.css' ); 
	add_editor_style( 'https://fonts.googleapis.com/css?family=Jost' );
 
}

// span to default widgets
function skagen_cat_count_span($links) {
  $links = str_replace('</a> (', '</a> <span class="cat_nr dnnc_rad_big">', $links);
  $links = str_replace(')', '</span>', $links);
  return $links;
}
add_filter('wp_list_categories', 'skagen_cat_count_span');



function skagen_archive_count($links) {
    $links = str_replace('</a>&nbsp;(', '</a> <span class="cat_nr">', $links);
    $links = str_replace(')', '</span>', $links);
    return $links;
}
add_filter('get_archives_link', 'skagen_archive_count');

// thumbnail for admin
/////////// 
// thumbnail for admin: section 1.
function skagen_get_featured_image($post_ID) {  
    $post_thumbnail_id = get_post_thumbnail_id($post_ID);  
    if ($post_thumbnail_id) {  
        $post_thumbnail_img = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail');  
        return $post_thumbnail_img[0];  
    }  
} 
// thumbnail for admin: section 2. ADD NEW COLUMN  
function skagen_columns_head($defaults) {  
	$defaults['featured_image'] = 'Featured Image';  
	return $defaults;  
}  
// thumbnail for admin: section 3. SHOW THE FEATURED IMAGE  
function skagen_columns_content($column_name, $post_ID) {  
	if ($column_name == 'featured_image') {  
		$post_featured_image = skagen_get_featured_image($post_ID);  
		if ($post_featured_image) {  
			echo '<img style=" width:100px;" src="' . $post_featured_image . '" />';  
		}  
	}  
}  
add_filter('manage_posts_columns', 'skagen_columns_head');  
add_action('manage_posts_custom_column', 'skagen_columns_content', 10, 2); 

/* That's all! */
?>