<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head><meta charset="<?php bloginfo( 'charset' ); ?>">

<!-- Set the viewport width to device width for mobile -->
<meta name="viewport" content="width=device-width, initial-scale=1" />

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php wp_head(); ?>

</head>

     
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div class="wrapper_main <?php $dannci_redux = get_option( 'dannci_redux' ); 
	if (!empty($dannci_redux['dnnc-uppercase']))  {echo esc_attr($dannci_redux['dnnc-uppercase']) . ' ';}
    if (!empty($dannci_redux['dnnc-header-layout']))  {echo esc_attr($dannci_redux['dnnc-header-layout']) . ' ';}
	if ( is_active_sidebar( 'dnnc-sidebar' ) ) {echo 'dnnc_sidebar_active ';} else { echo 'dnnc_sidebar_null ';};
?>">
   
    <div id="header" class="dnnc_border dnnc_tranz" itemscope itemtype="http://schema.org/WPHeader">
            
        <a class="screen-reader-text ribbon skip-link" href="#content_start"><?php esc_html_e('Skip to content','skagen');?></a>
                
            <div id="titles" class="dnnc_tranz">
            
                <?php if(empty($dannci_redux['dnnc-main-logo']['url'])) { ?>
                
                <h1 class="logo"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name');?></a></h1>
                
                <?php } 
                
                else { ?>
                        
                <a class="logo" href="<?php echo esc_url(home_url('/')); ?>">
                
                    <img class="dnnc_tranz this_is_logo" src="<?php echo esc_url($dannci_redux['dnnc-main-logo']['url']);?>" alt="<?php bloginfo('name'); ?>"/>
                        
                </a>
                
                <?php } ?>
            
            </div><!-- end #titles  -->
            
            <div class="for_menu <?php if ( has_nav_menu( 'main-menu' ) ) {echo 'show-menu-visible';}?>">
            
                <input type="checkbox" id="showmenu" aria-label="<?php esc_html_e('Open Menu','skagen');?>">
                <label for="showmenu" class="show-menu ribbon" tabindex="0"><i class="fas fa-bars"></i> <span><?php esc_html_e('Menu','skagen');?></span></label>
            
                <nav id="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement" role="navigation" aria-label="<?php esc_html_e( 'Main Menu', 'skagen' ); ?>"> 
                    
                    <?php get_template_part('/includes/navigation'); ?>
                
                </nav>
            
            </div><!-- end .for_menu  -->
    
    <div class="clearfix"></div>
    </div><!-- end #header  -->

<div class="clearfix"></div>
<div class="wrapper dnnc_border">