<?php

/*-----------------------------------------------------------------------------------*/
/* REDUX - speciable */
/*-----------------------------------------------------------------------------------*/

// editor style

add_action( 'init', 'skagen_add_editor_styles' );
function skagen_add_editor_styles() {
	$font_url = add_query_arg( 'family', urlencode( 'Jost:400,500,600,700,800,900,400italic,500italic,600italic,700italic,800italic&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
 	add_editor_style(  array($font_url, 'styles/reduxfall.css') );
}

// detect plugin 
if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
} else {
	
	function skagen_enqueue_reduxfall() {
		
		// Redux fallback
		wp_enqueue_style('reduxfall', get_template_directory_uri() . '/styles/reduxfall.css');
	
		// google link
		function dnnc_fonts_url() {
			$font_url = '';
			if ( 'off' !==  esc_attr_x( 'on', 'Google font: on or off','skagen')) {
				$font_url = add_query_arg( 'family', urlencode( 'Jost:400,500,600,700,400italic,700italic&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
			}
			return $font_url;
		}
		wp_enqueue_style( 'dnnc-fonts', dnnc_fonts_url(), array(), '1.0.0' );
		
	}
	add_action( 'wp_enqueue_scripts', 'skagen_enqueue_reduxfall' );
	
}

add_action('wp_footer', 'dnnc_bck_lnk');
function dnnc_bck_lnk(){ ?>
	<div class="dnnc_bck_lnk dnnc_border">
    <div class="dnnc_container">
      <a class="bck_lnk" target="_blank" title="Minimalistic WordPress Themes" href="http://dannci.com">Designed by Dannci</a>
    </div>
  </div>
<?php };


// one click import - detect plugin 
if ( class_exists( 'OCDI_Plugin' ) ) {

function dnnc_import_files() {
  return array(
  
  
  	// DEFAULT
    array(
      'import_file_name'           	=> 	'Default Demo',
      'import_file_url'            	=> 	'http://dannci.com/import/skagen/skagen.xml',
      'import_widget_file_url'     	=> 	'http://dannci.com/import/skagen/skagen-widgets.wie',
      'import_redux' => array(
				  array(
					'file_url'    	=> 	'http://dannci.com/import/skagen/skagen-redux.json',
					'option_name' 	=> 	'dannci_redux',
				  ),
      ),
      'import_preview_image_url'   	=> 	'http://dannci.com/import/skagen/skagen-screenshot.png',
      'preview_url'                	=> 	'http://dannci.com/demo/skagen/',
    ),

	
	
	
	
	// END OF ARRAY
	
  );
}
add_filter( 'pt-ocdi/import_files', 'dnnc_import_files' );


function dnnc_after_import_setup() {
    $main_menu = get_term_by( 'name', 'Main menu', 'nav_menu' );
    $bottom_menu = get_term_by( 'name', 'Footer menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'main-menu' => $main_menu->term_id,
            'bottom-menu' => $bottom_menu->term_id,
        )
    );

}
add_action( 'pt-ocdi/after_import', 'dnnc_after_import_setup' );

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

}

/*-----------------------------------------------------------------------------------*/
/* THE END */
/*-----------------------------------------------------------------------------------*/
?>