<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "dannci_redux";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme admin panel', 'skagen' ),
        'page_title'           => __( 'Theme admin panel', 'skagen' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => true,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    

    $args['admin_bar_links'][] = array(
        'href'   => 'https://www.elegantthemes.com/affiliates/idevaffiliate.php?id=2316',
        'target'   => '_blank',
        'title' => esc_html__( 'Get PRO with Divi', 'skagen' ),
    );
    $args['admin_bar_links'][] = array(
        'href'   => 'http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979',
        'target'   => '_blank',
        'title' => esc_html__( 'Fast and reliable hosting', 'skagen' ),
    );
    $args['admin_bar_links'][] = array(
                    'href'   => 'http://dannci.com/docs',
					'target'   => '_blank',
                    'title' => esc_html__( 'Documentation', 'skagen' ),
    );

    // Add content after the form.
    $args['footer_text'] = __( '<p>I recommend <a href="http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979" target="_blank">DreamHost for hosting</a> your WordPress website. <a href="#">Get PRO with DIVI</a></p>', '' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    // -> START Fields
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'General Settings','skagen' ),
                    'desc'   => esc_html__( '','skagen' ),
                    'icon'   => 'el el-cogs',
                    'fields' => array( // header end
					

                        array(
                            'id'       => 'dnnc-main-logo',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo','skagen' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','skagen' ),
                        ),	
						
												
                      	array(
                            'id'       => 'dnnc-uppercase',
                            'type'     => 'radio',
                            'title'    => esc_html__('Uppercase Fonts','skagen'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'upper_none' => esc_html__('None','skagen'),
                                'upper' => esc_html__('Minimal','skagen'),
                                'upper upper_medium' => esc_html__('Medium','skagen'),
                            ),
                            'default'  => 'upper upper_medium'
                        ),
						
						
                    )
					
					// section end
    ) );
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Primary Styling','skagen' ),
                    'desc'   => esc_html__( '','skagen' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end



						array(
                            'id'          => 'skagen-body-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Typography','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
							'all_styles'  => true,
                            'output'      => array( 'body,input,button,select,textarea,#wpmem_reg fieldset,#wpmem_login fieldset' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as the general text.','skagen' ),
                            'default'     => array(
                                'color'       => '#2f3133',
                                'font-style'  => '400',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '17px',
                            ),
                        ),

                        array(
                            'id'       => 'skagen-background',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Main Body Background','skagen' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','skagen' ),
							'transparent' => false,
                            'output'   => array('body,.dnnc_blogger .item_inn' ),
                            'default'     => array(
                                'background-color'       => '#f9f9f9',
                            ),
                        ),

                        array(
                            'id'       => 'skagen-link-color',
                            'type'     => 'link_color',
                            'title'    => esc_html__( 'Links Color Option','skagen' ),
                            'subtitle' => esc_html__( 'Pick a link color','skagen' ),
							'output'   => array( 'a' ),
                            'default'  => array(
                                'regular' => '#000',
                                'hover'   => '#ff5745',
                                'active'  => '#000',
                            )
                        ),
						

						
						array(
							'id'        => 'skagen-color-entry-link',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts)','skagen'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','skagen'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_entry p a,.dnnc_entry ol a,.dnnc_entry ul a,.elementor-text-editor a',
							)
						),
						
						
                        array(
                            'id'       => 'skagen-primary-border',
							'type'      => 'color',
							'title'     => esc_html__('Borders Color','skagen'),
							'subtitle'  => esc_html__('Pick a color for primary borders','skagen'),
							'transparent' => false,
							'default'   => '#ededed',
							'output'    => array(
								'border-color' => '.dnnc_border,.event_header p,input, textarea,select,.sidebar_item li,.comment-body,.tagcloud a,.page-numbers,.nav_item a,.dnnc_tags a',
							)
						),
						
	
                    )

					// section end
    ) );
	// Primary styling THE END
	
	
	
	
	
	
	// HEADER STYLING
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Header Styling','skagen' ),
                    'desc'   => esc_html__( '','skagen' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end

                        array(
                            'id'       => 'skagen-bg-header',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Header: Background','skagen' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','skagen' ),
							'transparent' => false,
                            'output'   => array('#header' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),


						array(
                            'id'          => 'skagen-site-title',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Site Title','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1.logo,h1.logo a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','skagen' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
						
						array(
							'id'        => 'skagen-link-title',
							'type'      => 'color',
							'title'     => esc_html__('Title Link Color','skagen'),
							'subtitle'  => esc_html__('Pick a color for header links.','skagen'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'color' => '.header_transparent .dnnc_page_header_plain h1,.header_transparent .dnnc_page_header_plain .crumb a',
							)
						),

						array(
                            'id'          => 'skagen-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Navigation Typography','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav>li>a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','skagen' ),
                            'default'     => array(
                                'color'       => '#2d2d2d',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '15px',
                            ),
                        ),
						
						array(
							'id'        => 'skagen-hover-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Navigation Links: Hover Color','skagen'),
							'subtitle'  => esc_html__('Pick a hover color for header links.','skagen'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'color' => '.nav a:hover,.nav li.current-menu-item>a,.nav >li>a:hover,#main-nav li.current-menu-ancestor>a',
							)
						),
						
						array(
							'id'        => 'nordkapdnnc_borders-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Header Borders Color','skagen'),
							'transparent' => false,
							'default'   => '#eee',
							'output'    => array(
								'border-color' => '#header.dnnc_border',
							)
						),
						

					
						array(
							'id'   => 'info_submenu',
							'type' => 'info',
							'title' => esc_html__('Sub-menu + Special menu button','skagen'),
							'style' => 'success',
						),


						array(
                            'id'          => 'skagen-sub-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Sub-menu Typography','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav ul li>a,.dnnc_tagline' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','skagen' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '400',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						
						
						array(
							'id'        => 'skagen-special-icon',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Icon Color','skagen'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '#main-nav>li.special>a i',
							)
						),


						array(
							'id'   => 'info_spacing',
							'type' => 'info',
							'title' => esc_html__('Spacing of the Header','skagen'),
							'style' => 'success',
						),

                        array(
                            'id'             => 'skagen-width-header',
                            'type'           => 'dimensions',
                            'output'   => array( '#titles .logo' ),
                            'units'          => 'px', 
                            'units_extended' => 'true',  
                            'height'          => false, 
                            'title'          => esc_html__( 'Header Title/Logo Width Option','skagen' ),
                            'subtitle'       => esc_html__( 'Choose the width limitation for the header logo.','skagen' ),
                            'default'        => array(
                                'width'  => '180px',
                            )
                        ),

                        array(
                            'id'       => 'skagen-spacing-header',
                            'type'     => 'spacing',
                            'output'   => array( '#titles .logo' ),
                            'mode'     => 'margin',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Title/Logo Spacing','skagen' ),
                            'subtitle' => esc_html__( 'Choose the margin for the header logo.','skagen' ),
                            'default'  => array(
                                'margin-top'    => '40px',
                                'margin-bottom' => '38px',
                            )
                        ),
						

                        array(
                            'id'       => 'skagen-spacing-nav',
                            'type'     => 'spacing',
                            'output'   => array( '#navigation>ul>li>a' ),
                            'mode'     => 'padding',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Navigation: Item Spacing','skagen' ),
                            'subtitle' => esc_html__( 'Choose the margin for header navigation.','skagen' ),
                            'default'  => array(
                                'padding-top'    => '4px',
                                'padding-bottom' => '4px',
                            )
                        ),

                    )
					// section end
    ) );
	// header styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Footer Styling','skagen' ),
                    'desc'   => esc_html__( '','skagen' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
						array(
							'id'        => 'skagen-color-myfooter',
							'type'      => 'background',
							'title'     => esc_html__('Footer: Background Color','skagen'),
							'subtitle'  => esc_html__('Pick a background color for the footer.','skagen'),
							'transparent' => false,
                            'output'   => array('#footer,#footer .searchform input.s,.footop-right,.dnnc_bck_lnk' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
						),
						
						array(
							'id'        => 'skagen-text-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Text: Color','skagen'),
							'subtitle'  => esc_html__('Pick a color for footer links.','skagen'),
							'transparent' => false,
							'default'   => '#727272',
							'output'    => array(
								'color' => '#footer p,#footer,#footer h4,#footer .bottom-menu a,.dnnc_bck_lnk,.dnnc_bck_lnk a',
							)
						),
						
						array(
							'id'        => 'skagen-links-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Color','skagen'),
							'subtitle'  => esc_html__('Pick a color for footer links.','skagen'),
							'transparent' => false,
							'default'   => '#2d2d2d',
							'output'    => array(
								'color' => '#footer a,#footer a span,#footer h2,#footer h2.footer_text,#footer h3,#footer .meta,#footer .meta a,#footer .searchform input.s,.footop ul.social-menu li span',
							)
						),
						
						array(
							'id'        => 'skagen-hover-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Hover Color','skagen'),
							'subtitle'  => esc_html__('Pick a hover color for footer links.','skagen'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '#footer a:hover,#footer a:hover span',
							)
						),
						
						
                        array(
                            'id'       => 'skagen-footer-border',
							'type'      => 'color',
							'title'     => esc_html__('Footer: Borders','skagen'),
							'subtitle'  => esc_html__('Pick a color for footer borders.','skagen'),
							'transparent' => false,
							'default'   => '#efefef',
							'output'    => array(
								'border-color' => '#footer .dnnc_border,.dnnc_bck_lnk,.dnnc_foocol li,#footer a,#footer .dnnc_social_icons li a,#footer .searchform input.s,#footer input',
							)
						), 
						
						
						array(
							'id'        => 'skagen-text-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Text / links Color','skagen'),
							'subtitle'  => esc_html__('Pick a text color for Special Footer.','skagen'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '#footop h2,.footop-left a,#foo-spec,#footer .dnnc_social_icons li a:hover,#footer .dnnc_social_icons li a:hover span',
							)
						),


			
						array(
                            'id'       => 'dnnc-footer-editor',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Text','skagen' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','skagen' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','skagen' ),
							'default'  => '',
                            'validate' => 'html',
						),
						
						array(
                            'id'       => 'dnnc-footer-credits',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Credits Text','skagen' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','skagen' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','skagen' ),
							'default'  => 'Copyright © 2021 - Skagen Theme',
                            'validate' => 'html',
						),
                    )

					// section end
    ) );
	// footer styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(                    
					'title'  => esc_html__( 'Typography','skagen' ),
                    'desc'   => esc_html__( '','skagen' ),
                    'icon'   => 'el el-bold',
                    'fields' => array( // header end
						
						
						array(
							'id'   => 'info_titles',
							'type' => 'info',
							'title' => esc_html__('Titles','skagen'),
							'style' => 'success',
						),	

						array(
                            'id'          => 'skagen-large',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Large Titles','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.large_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','skagen' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '34px',
                            ),
                        ),


						array(
                            'id'          => 'skagen-medium',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Medium Titles','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.medium_title,h2.footer_text' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','skagen' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),


						array(
                            'id'          => 'skagen-small',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Small Titles','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.small_title,.post_nav_text,.tptn_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','skagen' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),
						
						


						array(
                            'id'          => 'skagen-buttons',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Buttons Typography','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#submit,.dnnc_social_icons li a span,.mainbutton' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						


						array(
                            'id'          => 'skagen-inpost-headings',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'In Post Headings','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.dnnc_entry h1,.dnnc_entry h2,.dnnc_entry h3,.dnnc_entry h4,.dnnc_entry h5,.dnnc_entry h6' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the base typography for heading H1. Other headings sizes will be decreased accordingly.','skagen' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '46px',
                            ),
                        ),
                    )

					// section end
    ) );
	// typography styling THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Other Styling','skagen' ),
                    'desc'   => esc_html__( '','skagen' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
	
						
						array(
                            'id'          => 'skagen-meta',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Meta Sections: Font Style','skagen' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.dnnc_meta,.crumb,.post_nav_text span,.dnnc_tags a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for meta sections.','skagen' ),
                            'default'     => array(
                                'color'       => '#939597',
                                'font-weight'  => '500',
                                'font-family' => 'Jost',
                                'google'      => true,
                                'font-size'   => '12px',
                            ),
                        ),
						
						array(
							'id'        => 'skagen-meta-links',
							'type'      => 'color',
							'title'     => esc_html__('Meta Sections: Links Color','skagen'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_meta a'
								
							)
						),
						
						array(
							'id'        => 'skagen-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Color','skagen'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','skagen'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'background-color' => '.ribbon,a.mainbutton,.cat_nr,#respond #submit,.page-numbers.current,#submit,input[type="submit"],input.button,button.submit,#comments .navigation a,.reply a,.post_pagination_inn',
								'border-color' => 'input.button,button.submit,.page-link>span',
								
							)
						),
						
						array(
							'id'        => 'skagen-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Color','skagen'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','skagen'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '.ribbon,.ribbon a,a.ribbon,.ribbon p,#footer .ribbon,a.mainbutton,.cat_nr,.page-numbers.current,.format-quote blockquote,.reply a,#respond #submit,input[type="submit"],.post_pagination p a span',
							)
						),
						
						array(
							'id'        => 'skagen-hover-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Hover Color','skagen'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','skagen'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'background-color' => 'a.searchSubmit:hover,.ribbon:hover,a.mainbutton:hover,.meta_more a:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,h4.widget>span:after,.post_pagination p a:hover span,.owl-nav>div:hover',
								'border-color' => 'input.button:hover,button.submit:hover,.dnnc_tags a:hover'
							)
						),
						
						array(
							'id'        => 'skagen-hover-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Hover Color','skagen'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','skagen'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '#footer a.mainbutton:hover,.ribbon:hover,.ribbon:hover a,.ribbon a:hover,.ribbon:hover p,.entry a.ribbon:hover,a.mainbutton:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,.post_pagination p a:hover span,.owl-nav>div:hover',
							)
						),

                    )
					// section end
    ) );
	// other styling THE END
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
	//POST SETTINGS
    Redux::setSection( $opt_name, array(
                   'title'  => esc_html__( 'Post Settings','skagen' ),
                    'desc'   => esc_html__( '','skagen' ),
                    'icon'   => 'el el-edit',
                    'fields' => array( // header end

						
                        array(
                            'id'       => 'dnnc-post-meta-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Disable "Meta" sections','skagen' ),
                            'subtitle' => esc_html__( 'Tick to disable post "information" - date, category, etc. below post titles','skagen' ),
                            'desc'     => esc_html__( '','skagen' ),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-author-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Author Box','skagen' ),
                            'desc'     => esc_html__( '','skagen' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-tags-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Tags Section','skagen' ),
                            'desc'     => esc_html__( '','skagen' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-related-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Related Post Section','skagen' ),
                            'desc'     => esc_html__( '','skagen' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
                    )
					// section end
    ) );
	// post settings THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Social Networks','skagen'),
                    'icon'   => 'el el-share',
                    'fields' => array( // header end
				
					

                        array(
                            'id'       => 'dnnc-social-rss',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Rss Feed','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
                        array(
                            'id'       => 'dnnc-social-facebook',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Facebook','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-twitter',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Twitter','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tiktok',
                            'type'     => 'text',
                            'title'    => esc_html__( 'TikTok','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-pinterest',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Pinterest','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-instagram',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Instagram','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-youtube',
                            'type'     => 'text',
                            'title'    => esc_html__( 'You Tube','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-vimeo',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Vimeo','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tumblr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Tumblr','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-500',
                            'type'     => 'text',
                            'title'    => esc_html__( '500px','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-flickr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Flickr','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-linkedin',
                            'type'     => 'text',
                            'title'    => esc_html__( 'LinkedIn','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-foursquare',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Foursquare','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-dribbble',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Dribbble','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-skype',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Skype','skagen'),
                            'subtitle' => esc_html__( 'Enter skype URL','skagen'),
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-stumbleupon',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Stumbleupon','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-github',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Github','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-soundcloud',
                            'type'     => 'text',
                            'title'    => esc_html__( 'SoundCloud','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-spotify',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Spotify','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-buymeacoffee',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Buy Me a Coffee','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-xing',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Xing','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-whatsapp',
                            'type'     => 'text',
                            'title'    => esc_html__( 'WhatsApp','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-vk',
                            'type'     => 'text',
                            'title'    => esc_html__( 'VK','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-snapchat',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Snapchat','skagen'),
                            'subtitle' => esc_html__( 'Enter full URL','skagen'),
                            'validate' => 'url',
                        ),
                    )
					// section end
    ) );
	// social networks THE END	
	
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );


    /*
     * <--- END SECTIONS
     */
