<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "dannci_redux";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme admin panel', 'sorsele' ),
        'page_title'           => __( 'Theme admin panel', 'sorsele' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => true,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    

    $args['admin_bar_links'][] = array(
        'href'   => 'https://www.elegantthemes.com/affiliates/idevaffiliate.php?id=2316',
        'target'   => '_blank',
        'title' => esc_html__( 'Get PRO with Divi', 'sorsele' ),
    );
    $args['admin_bar_links'][] = array(
        'href'   => 'http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979',
        'target'   => '_blank',
        'title' => esc_html__( 'Fast and reliable hosting', 'sorsele' ),
    );
    $args['admin_bar_links'][] = array(
                    'href'   => 'http://dannci.com/docs',
					'target'   => '_blank',
                    'title' => esc_html__( 'Documentation', 'sorsele' ),
    );

    // Add content after the form.
    $args['footer_text'] = __( '<p>I recommend <a href="http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979" target="_blank">DreamHost for hosting</a> your WordPress website. <a href="#">Get PRO with DIVI</a></p>', '' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    // -> START Fields
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'General Settings','sorsele' ),
                    'desc'   => esc_html__( '','sorsele' ),
                    'icon'   => 'el el-cogs',
                    'fields' => array( // header end
					

                        array(
                            'id'       => 'dnnc-main-logo',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo','sorsele' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','sorsele' ),
                        ),		                        
                        
                        array(
                            'id'       => 'dnnc-main-logo-inv',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo for Transparent Header','sorsele' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','sorsele' ),
                        ),
						
						array(
                            'id'       => 'dnnc-blog-layout',
                            'type'     => 'radio',
                            'title'    => esc_html__('Blog Layout','sorsele'),
                            'subtitle' => esc_html__('Select layout and styling for the blog template','sorsele'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'dnnc_blogger_sidebar' => esc_html__('With Sidebar','sorsele'),
                                'dnnc_blogger_full_width' => esc_html__('Without Sidebar','sorsele'),
                            ),
                            'default'  => 'dnnc_blogger_sidebar'
                        ),



                        
						
						
                        array(
                            'id'       => 'tmnf-slider-dis',
                            'type'     => 'checkbox',
                            'title'    => __( 'Enable Homepage Slider','sorsele'),
                            'subtitle' => __( 'You can enable slider here.','sorsele'),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						 array(
							'id' => 'tmnf-slider-cats',
							'type' => 'select',
							'data' => 'categories',
							'multi' => true,
							'title' => esc_html__('Homepage Slider: Featured categories (required)','sorsele'),
							'subtitle' => esc_html__('','sorsele'),
							'desc' => esc_html__('','sorsele'),
							'default'  => ''
						),
						
						 array(
							'id' => 'tmnf-slider-nr',
							'type' => 'select',
							'title' => esc_html__('Homepage Slider: Number of posts','sorsele'),
							'subtitle' => esc_html__('','sorsele'),
							'desc' => __('','sorsele'),
							'options'  => array(
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                                '9' => '9',
                                '10' => '10',
							),
							'default'  => '4'
						),
						
						
												
                      	array(
                            'id'       => 'dnnc-uppercase',
                            'type'     => 'radio',
                            'title'    => esc_html__('Uppercase Fonts','sorsele'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'upper_none' => esc_html__('None','sorsele'),
                                'upper' => esc_html__('Minimal','sorsele'),
                                'upper upper_medium' => esc_html__('Medium','sorsele'),
                                'upper upper_medium upper_maxi' => esc_html__('Maxi','sorsele'),
                            ),
                            'default'  => 'upper'
                        ),
						
						
                    )
					
					// section end
    ) );
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Primary Styling','sorsele' ),
                    'desc'   => esc_html__( '','sorsele' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end



						array(
                            'id'          => 'sorsele-body-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Typography','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
							'all_styles'  => true,
                            'output'      => array( 'body,input,button,select,textarea,#wpmem_reg fieldset,#wpmem_login fieldset,.dnnc_blogger .item_inn' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as the general text.','sorsele' ),
                            'default'     => array(
                                'color'       => '#3d3b3a',
                                'font-style'  => '400',
                                'font-family' => 'Public Sans',
                                'google'      => true,
                                'font-size'   => '18px',
                            ),
                        ),

                        array(
                            'id'       => 'sorsele-background',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Main Body Background','sorsele' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','sorsele' ),
							'transparent' => false,
                            'output'   => array('body,.dnnc_blogger .item_inn' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),
						
						array(
							'id'        => 'sorsele-color-dnnc_ghost',
							'type'      => 'color',
							'title'     => esc_html__('Ghost Background Color','sorsele'),
							'subtitle'  => esc_html__('Pick an alternative background color (similar to Main Body Background)','sorsele'),
							'transparent' => false,
							'default'   => '#f9f9f9',
							'output'    => array(
								'background-color' => '.dnnc_ghost,.single .give-goal-progress,.sidebar_item,#comments .navigation a,a.page-numbers,.page-numbers.dots'
							)
						),

                        array(
                            'id'       => 'sorsele-link-color',
                            'type'     => 'link_color',
                            'title'    => esc_html__( 'Links Color Option','sorsele' ),
                            'subtitle' => esc_html__( 'Pick a link color','sorsele' ),
							'output'   => array( 'a' ),
                            'default'  => array(
                                'regular' => '#000',
                                'hover'   => '#ff5745',
                                'active'  => '#000',
                            )
                        ),
						

						
						array(
							'id'        => 'sorsele-color-entry-link',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts)','sorsele'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','sorsele'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_entry p a,.dnnc_entry ol a,.dnnc_entry ul a,.elementor-text-editor a',
							)
						),
						

						
						array(
							'id'        => 'sorsele-color-entry-link-hover',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts): Hover Background Color','sorsele'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','sorsele'),
							'transparent' => false,
							'default'   => '#555',
							'output'    => array(
								'background-color' => '.dnnc_entry p a:hover,.dnnc_entry li a:hover',
							)
						),
						
                        array(
                            'id'       => 'sorsele-primary-border',
							'type'      => 'color',
							'title'     => esc_html__('Borders Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for primary borders','sorsele'),
							'transparent' => false,
							'default'   => '#ededed',
							'output'    => array(
								'border-color' => '.dnnc_border,.event_header p,input, textarea,select,.sidebar_item li,.comment-body,.tagcloud a,.page-numbers,.nav_item a,.dnnc_tags a',
							)
						),
						
						array(
							'id'        => 'sorsele-text-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Text Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for sidebar text.','sorsele'),
							'transparent' => false,
							'default'   => '#939597',
							'output'    => array(
								'color' => '#sidebar,.post-pagination span',
							)
						),
						
						array(
							'id'        => 'sorsele-links-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','sorsele'),
							'transparent' => false,
							'default'   => '#000000',
							'output'    => array(
								'color' => '.widgetable a',
							)
						),
						
						array(
							'id'        => 'sorsele-links-sidebar-hover',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link: Hover Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','sorsele'),
							'transparent' => false,
							'default'   => '#666',
							'output'    => array(
								'color' => '.widgetable a:hover',
							)
						),
                    )

					// section end
    ) );
	// Primary styling THE END
	
	
	
	
	
	
	// HEADER STYLING
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Header Styling','sorsele' ),
                    'desc'   => esc_html__( '','sorsele' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
										
                      	array(
                            'id'       => 'dnnc-header-layout',
                            'type'     => 'radio',
                            'title'    => esc_html__('Header Layout','sorsele'),
                            'subtitle' => esc_html__('Select layout for your header','sorsele'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'header_default' => esc_html__('Default Header','sorsele'),
                                'header_fullwidth' => esc_html__('Full Width Header','sorsele'),
                            ),
                            'default'  => 'header_fullwidth'
                        ),

                        array(
                            'id'       => 'sorsele-bg-header',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Header: Background','sorsele' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','sorsele' ),
							'transparent' => false,
                            'output'   => array('#header,.dnnc_slider_wrap' ),
                            'default'     => array(
                                'background-color'       => '#D73D0F',
                            ),
                        ),


						array(
                            'id'          => 'sorsele-site-title',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Site Title','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#titles h1,#titles h1 a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','sorsele' ),
                            'default'     => array(
                                'color'       => '#622222',
                                'font-weight'  => '800',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
						
						array(
							'id'        => 'sorsele-link-title',
							'type'      => 'color',
							'title'     => esc_html__('Title Link Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for header links.','sorsele'),
							'transparent' => false,
							'default'   => '#622222',
							'output'    => array(
								'color' => '.dnnc_slider_wrap a',
							)
						),

						array(
                            'id'          => 'sorsele-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Navigation Typography','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav>li>a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','sorsele' ),
                            'default'     => array(
                                'color'       => '#622222',
                                'font-weight'  => '700',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),
						
						array(
							'id'        => 'sorsele-hover-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Navigation Links: Hover Color','sorsele'),
							'subtitle'  => esc_html__('Pick a hover color for header links.','sorsele'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'border-color' => '.nav > li.current-menu-item>a,.nav >li>a:hover,#main-nav li.current-menu-ancestor>a',
							)
						),
						
						array(
							'id'        => 'nordkapdnnc_borders-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Header Borders Color','sorsele'),
							'transparent' => false,
							'default'   => '#eee',
							'output'    => array(
								'border-color' => '#header.dnnc_border',
							)
						),
						

					
						array(
							'id'   => 'info_submenu',
							'type' => 'info',
							'title' => esc_html__('Sub-menu + Special menu button','sorsele'),
							'style' => 'success',
						),
						
						
						
						array(
							'id'        => 'sorsele-sub-bg-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Sub-menu Background Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for header text.','sorsele'),
							'transparent' => false,
							'default'   => '#622222',
							'output'    => array(
								'background-color' => '.nav li ul',
								'border-left-color' => '.nav>li>ul:after,.nav > li.mega:hover::after',
								'border-right-color' => 'body.rtl .nav>li>ul:after,body.rtl .nav > li.mega:hover::after',
							)
						),


						array(
                            'id'          => 'sorsele-sub-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Sub-menu Typography','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav ul li>a,.dnnc_tagline' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','sorsele' ),
                            'default'     => array(
                                'color'       => '#ea8e72',
                                'font-weight'  => '500',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '15px',
                            ),
                        ),
						

						
						
						array(
							'id'        => 'sorsele-special-bg',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Background Color','sorsele'),
							'transparent' => false,
							'default'   => '#762929',
							'output'    => array(
								'background-color' => '#main-nav>li.special>a,.owl-nav>div,#header .dnnc_social_icons li a',
                                
							)
						),
						
						array(
							'id'        => 'sorsele-special-bg-hover',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Hover Background Color','sorsele'),
							'transparent' => false,
							'default'   => '#4b0d0d',
							'output'    => array(
								'background-color' => '#main-nav>li.special>a:hover,.owl-nav>div:hover:hover,#header .dnnc_social_icons li a:hover',
							)
						),
						
						
						array(
							'id'        => 'sorsele-special-text',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Text Color','sorsele'),
							'transparent' => false,
							'default'   => '#D73D0F',
							'output'    => array(
								'color' => '#main-nav>li.special>a,#main-nav>li.special>a:hover i,.owl-nav>div,#header .dnnc_social_icons li a',
							)
						),
						
						
						array(
							'id'        => 'sorsele-special-icon',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Icon Color','sorsele'),
							'transparent' => false,
							'default'   => '#D73D0F',
							'output'    => array(
								'color' => '#main-nav>li.special>a i',
							)
						),

						array(
							'id'   => 'tmnf-info-trans',
							'type' => 'info',
							'title' => esc_html__('Transparent Header','sorsele'),
							'style' => 'success',
						),
						
						
						array(
							'id'        => 'sorsele-images-bg',
							'type'      => 'color',
							'title'     => esc_html__('Transparent Header: Background Color (fallback)','sorsele'),
							'transparent' => false,
							'default'   => '#1E1E1E',
							'output'    => array(
								'background-color' => '[class*="hero-cover"]  #header,.imgwrap,.dnnc_page_header_image,.post_nav_image,.tmnf_respo_magic #navigation',
                                'color' => '[class*="hero-cover"] #header .dnnc_social_icons li a',
                                )
						),
						
						
						
						array(
							'id'        => 'sorsele-images-text',
							'type'      => 'color',
							'title'     => esc_html__('Transparent Header: Text Color','sorsele'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '[class*="hero-cover"] #titles h1 a,[class*="hero-cover"]  #header .nav > li > a,.dnnc_page_header_image,.dnnc_page_header_image p,.dnnc_page_header_image a,.dnnc_page_header_image h1,.dnnc_page_header_image .dnnc_meta a,.post_nav_image .arrow,.tmnf_respo_magic #navigation li:not(.special) a',
                                'background-color' => '[class*="hero-cover"] #header .dnnc_social_icons li a',
                            )
						),



						array(
							'id'   => 'info_spacing',
							'type' => 'info',
							'title' => esc_html__('Spacing of the Header','sorsele'),
							'style' => 'success',
						),

                        array(
                            'id'             => 'sorsele-width-header',
                            'type'           => 'dimensions',
                            'output'   => array( '#titles' ),
                            'units'          => 'px', 
                            'units_extended' => 'true',  
                            'height'          => false, 
                            'title'          => esc_html__( 'Header Title/Logo Width Option','sorsele' ),
                            'subtitle'       => esc_html__( 'Choose the width limitation for the header logo.','sorsele' ),
                            'default'        => array(
                                'width'  => '180px',
                            )
                        ),

                        array(
                            'id'       => 'sorsele-spacing-header',
                            'type'     => 'spacing',
                            'output'   => array( '#titles' ),
                            'mode'     => 'margin',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Title/Logo Spacing','sorsele' ),
                            'subtitle' => esc_html__( 'Choose the margin for the header logo.','sorsele' ),
                            'default'  => array(
                                'margin-top'    => '40px',
                                'margin-bottom' => '38px',
                            )
                        ),
						

                        array(
                            'id'       => 'sorsele-spacing-nav',
                            'type'     => 'spacing',
                            'output'   => array( '#navigation>ul,#header .dnnc_social_icons' ),
                            'mode'     => 'padding',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Navigation Spacing','sorsele' ),
                            'subtitle' => esc_html__( 'Choose the margin for header navigation.','sorsele' ),
                            'default'  => array(
                                'padding-top'    => '31px',
                                'padding-bottom' => '29px',
                            )
                        ),

                    )
					// section end
    ) );
	// header styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Footer Styling','sorsele' ),
                    'desc'   => esc_html__( '','sorsele' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
						array(
							'id'        => 'sorsele-color-myfooter',
							'type'      => 'background',
							'title'     => esc_html__('Footer: Background Color','sorsele'),
							'subtitle'  => esc_html__('Pick a background color for the footer.','sorsele'),
							'transparent' => false,
                            'output'   => array('#footer,#footer .searchform input.s,.footop-right,.dnnc_bck_lnk' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
						),
						
						array(
							'id'        => 'sorsele-text-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Text: Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for footer links.','sorsele'),
							'transparent' => false,
							'default'   => '#515151',
							'output'    => array(
								'color' => '#footer p,#footer,#footer h4,#footer .bottom-menu a,.dnnc_bck_lnk,.dnnc_bck_lnk a',
							)
						),
						
						array(
							'id'        => 'sorsele-links-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Color','sorsele'),
							'subtitle'  => esc_html__('Pick a color for footer links.','sorsele'),
							'transparent' => false,
							'default'   => '#3d3d3d',
							'output'    => array(
								'color' => '#footer a,#footer a span,#footer h2,#footer h3,#footer .meta,#footer .meta a,#footer .searchform input.s,.footop ul.social-menu li span',
							)
						),
						
						array(
							'id'        => 'sorsele-hover-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Hover Color','sorsele'),
							'subtitle'  => esc_html__('Pick a hover color for footer links.','sorsele'),
							'transparent' => false,
							'default'   => '#D73D0F',
							'output'    => array(
								'color' => '#footer a:hover,#footer a:hover span',
							)
						),
						
						
                        array(
                            'id'       => 'sorsele-footer-border',
							'type'      => 'color',
							'title'     => esc_html__('Footer: Borders','sorsele'),
							'subtitle'  => esc_html__('Pick a color for footer borders.','sorsele'),
							'transparent' => false,
							'default'   => '#efefef',
							'output'    => array(
								'border-color' => '#footer .dnnc_border,.dnnc_bck_lnk,.dnnc_foocol li,#footer a,#footer .dnnc_social_icons li a,#footer .searchform input.s,#footer input',
							)
						), 
						
						array(
							'id'   => 'info_special_footer',
							'type' => 'info',
							'title' => esc_html__('Special Footer Section (above the footer)','sorsele'),
							'style' => 'success',
						),	
						
						
						array(
							'id'        => 'sorsele-bg-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Background Color','sorsele'),
							'subtitle'  => esc_html__('Pick a background color for Special Footer.','sorsele'),
							'transparent' => false,
							'default'   => '#D73D0F',
							'output'    => array(
								'background-color' => '.footop,.dnnc_social_icons li a:hover',
							)
						),
						
						
						array(
							'id'        => 'sorsele-text-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Text / links Color','sorsele'),
							'subtitle'  => esc_html__('Pick a text color for Special Footer.','sorsele'),
							'transparent' => false,
							'default'   => '#622222',
							'output'    => array(
								'color' => '#footop h2,.footop-left a,#foo-spec,#footer .dnnc_social_icons li a:hover,#footer .dnnc_social_icons li a:hover span',
							)
						),


			
						array(
                            'id'       => 'dnnc-footer-editor',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Text','sorsele' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','sorsele' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','sorsele' ),
							'default'  => '',
                            'validate' => 'html',
						),
						
						array(
                            'id'       => 'dnnc-footer-credits',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Credits Text','sorsele' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','sorsele' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','sorsele' ),
							'default'  => 'Copyright © 2023 - Sorsele Theme',
                            'validate' => 'html',
						),
                    )

					// section end
    ) );
	// footer styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(                    
					'title'  => esc_html__( 'Typography','sorsele' ),
                    'desc'   => esc_html__( '','sorsele' ),
                    'icon'   => 'el el-bold',
                    'fields' => array( // header end
						
						
						array(
							'id'   => 'info_titles',
							'type' => 'info',
							'title' => esc_html__('Titles','sorsele'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'sorsele-large',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Large Titles','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.large_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '800',
                                'font-family' => 'Barlow Condensed',
                                'google'      => true,
                                'font-size'   => '120px',
                            ),
                        ),


						array(
                            'id'          => 'sorsele-medium',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Medium Titles','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.medium_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '800',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '26px',
                            ),
                        ),


						array(
                            'id'          => 'sorsele-small',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Small Titles','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.small_title,.post_nav_text,.tptn_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '700',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),
						
						


						array(
                            'id'          => 'sorsele-buttons',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Buttons Typography','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#submit,.dnnc_social_icons li a span,.mainbutton' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						
						
						
						array(
							'id'   => 'info_headings',
							'type' => 'info',
							'title' => esc_html__('Basic (in post) Headings','sorsele'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'sorsele-h1',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H1 Font Style','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H1.','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '800',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '46px',
                            ),
                        ),
						
						array(
                            'id'          => 'sorsele-h2',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H2 Font Style','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h2' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H2.','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '800',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '36px',
                            ),
                        ),
						
						array(
                            'id'          => 'sorsele-h3',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H3 Font Style','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h3,blockquote' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H3.','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '800',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '32px',
                            ),
                        ),
						
						array(
                            'id'          => 'sorsele-h4',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H4 Font Style','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h4' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H4.','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '700',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),
						
						array(
                            'id'          => 'sorsele-h5',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H5 Font Style','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h5,h6' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H5.','sorsele' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
                    )

					// section end
    ) );
	// typography styling THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Other Styling','sorsele' ),
                    'desc'   => esc_html__( '','sorsele' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
	
						
						array(
                            'id'          => 'sorsele-meta',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Meta Sections: Font Style','sorsele' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.dnnc_meta,.crumb,.post_nav_text span,.dnnc_tags a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for meta sections.','sorsele' ),
                            'default'     => array(
                                'color'       => '#622222',
                                'font-weight'  => '500',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '10px',
                            ),
                        ),
						
						array(
							'id'        => 'sorsele-meta-links',
							'type'      => 'color',
							'title'     => esc_html__('Meta Sections: Links Color','sorsele'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_meta a'
								
							)
						),
						
						array(
							'id'        => 'sorsele-color-dividers',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Background','sorsele'),
							'transparent' => false,
							'default'   => '#622222',
							'output'    => array(
								'background-color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs',
								'color' => '.main-breadcrumbs span::after'
								
							)
						),
						
						array(
							'id'        => 'sorsele-color-dividers-text',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Text','sorsele'),
							'transparent' => false,
							'default'   => '#d73d0f',
							'output'    => array(
								'color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs,.dnnc_meta_categs a',
								
							)
						),
						
						array(
							'id'        => 'sorsele-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Color','sorsele'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','sorsele'),
							'transparent' => false,
							'default'   => '#D73D0F',
							'output'    => array(
								'background-color' => '.ribbon,a.mainbutton,.cat_nr,#respond #submit,.page-numbers.current,#submit,input[type="submit"],input.button,button.submit,#comments .navigation a,.reply a,.post_pagination_inn',
								'border-color' => 'input.button,button.submit,.page-link>span',
								
							)
						),
						
						array(
							'id'        => 'sorsele-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Color','sorsele'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','sorsele'),
							'transparent' => false,
							'default'   => '#ffcccc',
							'output'    => array(
								'color' => '.ribbon,.ribbon a,a.ribbon,.ribbon p,#footer .ribbon,a.mainbutton,.cat_nr,.page-numbers.current,.format-quote blockquote,.reply a,#respond #submit,input[type="submit"],.post_pagination p a span',
							)
						),
						
						array(
							'id'        => 'sorsele-hover-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Hover Color','sorsele'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','sorsele'),
							'transparent' => false,
							'default'   => '#622222',
							'output'    => array(
								'background-color' => 'a.searchSubmit:hover,.ribbon:hover,a.mainbutton:hover,.meta_more a:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,h4.widget>span:after,.post_pagination p a:hover span',
								'border-color' => 'input.button:hover,button.submit:hover,.dnnc_tags a:hover'
							)
						),
						
						array(
							'id'        => 'sorsele-hover-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Hover Color','sorsele'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','sorsele'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '#footer a.mainbutton:hover,.ribbon:hover,.ribbon:hover a,.ribbon a:hover,.ribbon:hover p,.entry a.ribbon:hover,a.mainbutton:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,.post_pagination p a:hover span',
							)
						),
						
						

                    )
					// section end
    ) );
	// other styling THE END
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
	//POST SETTINGS
    Redux::setSection( $opt_name, array(
                   'title'  => esc_html__( 'Post Settings','sorsele' ),
                    'desc'   => esc_html__( '','sorsele' ),
                    'icon'   => 'el el-edit',
                    'fields' => array( // header end

						
                        array(
                            'id'       => 'dnnc-post-meta-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Disable "Meta" sections','sorsele' ),
                            'subtitle' => esc_html__( 'Tick to disable post "information" - date, category, etc. below post titles','sorsele' ),
                            'desc'     => esc_html__( '','sorsele' ),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-author-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Author Box','sorsele' ),
                            'desc'     => esc_html__( '','sorsele' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-tags-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Tags Section','sorsele' ),
                            'desc'     => esc_html__( '','sorsele' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-related-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Related Post Section','sorsele' ),
                            'desc'     => esc_html__( '','sorsele' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
                    )
					// section end
    ) );
	// post settings THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Social Networks','sorsele'),
                    'icon'   => 'el el-share',
                    'fields' => array( // header end
				
					

                        array(
                            'id'       => 'dnnc-social-rss',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Rss Feed','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
                        array(
                            'id'       => 'dnnc-social-facebook',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Facebook','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-twitter',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Twitter','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tiktok',
                            'type'     => 'text',
                            'title'    => esc_html__( 'TikTok','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-pinterest',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Pinterest','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-instagram',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Instagram','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-youtube',
                            'type'     => 'text',
                            'title'    => esc_html__( 'You Tube','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-vimeo',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Vimeo','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tumblr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Tumblr','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-500',
                            'type'     => 'text',
                            'title'    => esc_html__( '500px','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-flickr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Flickr','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-linkedin',
                            'type'     => 'text',
                            'title'    => esc_html__( 'LinkedIn','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-foursquare',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Foursquare','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-dribbble',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Dribbble','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-skype',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Skype','sorsele'),
                            'subtitle' => esc_html__( 'Enter skype URL','sorsele'),
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-stumbleupon',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Stumbleupon','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-github',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Github','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-soundcloud',
                            'type'     => 'text',
                            'title'    => esc_html__( 'SoundCloud','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-spotify',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Spotify','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-xing',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Xing','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-whatsapp',
                            'type'     => 'text',
                            'title'    => esc_html__( 'WhatsApp','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-vk',
                            'type'     => 'text',
                            'title'    => esc_html__( 'VK','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-snapchat',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Snapchat','sorsele'),
                            'subtitle' => esc_html__( 'Enter full URL','sorsele'),
                            'validate' => 'url',
                        ),
                    )
					// section end
    ) );
	// social networks THE END	
	
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );


    /*
     * <--- END SECTIONS
     */
