<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "dannci_redux";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme admin panel', 'visby' ),
        'page_title'           => __( 'Theme admin panel', 'visby' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => true,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    

    $args['admin_bar_links'][] = array(
        'href'   => 'https://www.buymeacoffee.com/dannci',
        'target'   => '_blank',
        'title' => esc_html__( 'Buy Me a Coffee', 'visby' ),
    );
    $args['admin_bar_links'][] = array(
                    'href'   => 'http://dannci.com/docs',
					'target'   => '_blank',
                    'title' => esc_html__( 'Documentation', 'visby' ),
    );

    // Add content after the form.
    $args['footer_text'] = __( '<p>I recommend <a href="http://click.dreamhost.com/aff_c?offer_id=77&aff_id=6979" target="_blank">DreamHost for hosting</a> your WordPress website. <a href="#">Get PRO with DIVI</a></p>', '' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    // -> START Fields
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'General Settings','visby' ),
                    'desc'   => esc_html__( '','visby' ),
                    'icon'   => 'el el-cogs',
                    'fields' => array( // header end
					

                        array(
                            'id'       => 'dnnc-main-logo',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo','visby' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','visby' ),
                        ),		                        
                        
                        array(
                            'id'       => 'dnnc-main-logo-inv',
                            'type'     => 'media',
							'default'  => '',
							'readonly' => false,
                            'preview'  => true,
							'url'      => true,
                            'title'    => esc_html__( 'Main Logo for Transparent Header','visby' ),
                            'desc'     => esc_html__( 'Upload a logo for your theme','visby' ),
                        ),
						
												
                      	array(
                            'id'       => 'dnnc-uppercase',
                            'type'     => 'radio',
                            'title'    => esc_html__('Uppercase Fonts','visby'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'upper_none' => esc_html__('None','visby'),
                                'upper' => esc_html__('Minimal','visby'),
                                'upper upper_medium' => esc_html__('Medium','visby'),
                                'upper upper_medium upper_maxi' => esc_html__('Maxi','visby'),
                            ),
                            'default'  => 'upper upper_medium'
                        ),



												
                        array(
                            'id'       => 'dnnc-image-filter',
                            'type'     => 'radio',
                            'title'    => esc_html__('Images Filter','visby'),
                            //Must provide key => value pairs for radio options
                            'options'  => array(
                                'image_css_none' => esc_html__('None','visby'),
                                'image_css_desaturate' => esc_html__('Desaturate','visby'),
                                'image_css_desaturate_almost' => esc_html__('Desaturate 80%','visby'),
                                'image_css_desaturate_half' => esc_html__('Desaturate 50%','visby'),
                                'image_css_sepia' => esc_html__('Sepia','visby'),
                                'image_css_bright' => esc_html__('Bright','visby'),
                            ),
                            'default'  => 'image_css_none'
                        ),


                        
						array(
							'id'   => 'info_slider',
							'type' => 'info',
							'title' => esc_html__('Main Slider','visby'),
							'style' => 'success',
						),
						
                        array(
                            'id'       => 'dnnc-slider-dis',
                            'type'     => 'checkbox',
                            'title'    => __( 'Enable Homepage Slider','visby'),
                            'subtitle' => __( 'You can enable slider here.','visby'),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						 array(
							'id' => 'dnnc-slider-cats',
							'type' => 'select',
							'data' => 'categories',
							'multi' => true,
							'title' => esc_html__('Homepage Slider: Featured categories (required)','visby'),
							'subtitle' => esc_html__('','visby'),
							'desc' => esc_html__('','visby'),
							'default'  => ''
						),
						
						 array(
							'id' => 'dnnc-slider-nr',
							'type' => 'select',
							'title' => esc_html__('Homepage Slider: Number of posts','visby'),
							'subtitle' => esc_html__('','visby'),
							'desc' => __('','visby'),
							'options'  => array(
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                                '9' => '9',
                                '10' => '10',
							),
							'default'  => '4'
						),
						
						
                    )
					
					// section end
    ) );
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Primary Styling','visby' ),
                    'desc'   => esc_html__( '','visby' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end



						array(
                            'id'          => 'visby-body-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Typography','visby' ),
                            'google'      => true,
                            'font-backup' => true,
							'all_styles'  => true,
                            'output'      => array( 'body,input,button,select,textarea,#wpmem_reg fieldset,#wpmem_login fieldset,.dnnc_blogger .item_inn' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as the general text.','visby' ),
                            'default'     => array(
                                'color'       => '#222',
                                'font-style'  => '400',
                                'font-family' => 'Libre Franklin',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),

                        array(
                            'id'       => 'visby-background',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Main Body Background','visby' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','visby' ),
							'transparent' => false,
                            'output'   => array('body,.dnnc_bck_lnk' ),
                            'default'     => array(
                                'background-color'       => '#cecece',
                            ),
                        ),
						
						array(
							'id'        => 'visby-color-dnnc_ghost',
							'type'      => 'color',
							'title'     => esc_html__('Ghost Background Color','visby'),
							'subtitle'  => esc_html__('Pick an alternative background color (similar to Main Body Background)','visby'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'background-color' => '.wrapper_main '
							)
						),

                        array(
                            'id'       => 'visby-link-color',
                            'type'     => 'link_color',
                            'title'    => esc_html__( 'Links Color Option','visby' ),
                            'subtitle' => esc_html__( 'Pick a link color','visby' ),
							'output'   => array( 'a' ),
                            'default'  => array(
                                'regular' => '#000',
                                'hover'   => '#ff5745',
                                'active'  => '#000',
                            )
                        ),
						

						
						array(
							'id'        => 'visby-color-entry-link',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts)','visby'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','visby'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_entry p a,.dnnc_entry ol a,.dnnc_entry ul a,.elementor-text-editor a',
							)
						),
						

						
						array(
							'id'        => 'visby-color-entry-link-hover',
							'type'      => 'color',
							'title'     => esc_html__('Entry Links (in post texts): Hover Background Color','visby'),
							'subtitle'  => esc_html__('Pick a custom color for post links.','visby'),
							'transparent' => false,
							'default'   => '#555',
							'output'    => array(
								'background-color' => '.dnnc_entry p a:hover,.dnnc_entry li a:hover',
							)
						),
						
                        array(
                            'id'       => 'visby-primary-border',
							'type'      => 'color',
							'title'     => esc_html__('Primary Borders Color','visby'),
							'subtitle'  => esc_html__('Pick a color for primary borders','visby'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'border-color' => '.dnnc_border_main,.sidebar_item,#main_menu>li',
							)
						),
						
                        array(
                            'id'       => 'visby-secondary-border',
							'type'      => 'color',
							'title'     => esc_html__('Secondary Borders Color','visby'),
							'subtitle'  => esc_html__('Pick a color for primary borders','visby'),
							'transparent' => false,
							'default'   => '#ededed',
							'output'    => array(
								'border-color' => '.dnnc_border,.event_header p,input, textarea,select,.sidebar_item li,.comment-body,.tagcloud a,.page-numbers,.nav_item a,.dnnc_tags a',
							)
						),
						
						array(
							'id'        => 'visby-text-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Text Color','visby'),
							'subtitle'  => esc_html__('Pick a color for sidebar text.','visby'),
							'transparent' => false,
							'default'   => '#939597',
							'output'    => array(
								'color' => '#sidebar,.post-pagination span',
							)
						),
						
						array(
							'id'        => 'visby-links-sidebar',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link Color','visby'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','visby'),
							'transparent' => false,
							'default'   => '#000000',
							'output'    => array(
								'color' => '.widgetable a',
							)
						),
						
						array(
							'id'        => 'visby-links-sidebar-hover',
							'type'      => 'color',
							'title'     => esc_html__('Sidebar Link: Hover Color','visby'),
							'subtitle'  => esc_html__('Pick a color for sidebar links.','visby'),
							'transparent' => false,
							'default'   => '#666',
							'output'    => array(
								'color' => '.widgetable a:hover',
							)
						),
                    )

					// section end
    ) );
	// Primary styling THE END
	
	
	
	
	
	
	// HEADER STYLING
    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Header Styling','visby' ),
                    'desc'   => esc_html__( '','visby' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end

                        array(
                            'id'       => 'visby-bg-header',
                            'type'     => 'background',
                            'title'    => esc_html__( 'Header: Background','visby' ),
                            'subtitle' => esc_html__( 'Body background with image, color, etc.','visby' ),
							'transparent' => false,
                            'output'   => array('#header,.dnnc_slider_wrap' ),
                            'default'     => array(
                                'background-color'       => '#fff',
                            ),
                        ),


						array(
                            'id'          => 'visby-site-title',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Site Title','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#titles h1,#titles h1 a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'default'     => array(
                                'color'       => '#3a3a3a',
                                'font-weight'  => '800',
                                'font-family' => 'Fira Sans Condensed',
                                'google'      => true,
                                'font-size'   => '38px',
                            ),
                        ),
						
						array(
							'id'        => 'visby-link-title',
							'type'      => 'color',
							'title'     => esc_html__('Title Link Color','visby'),
							'subtitle'  => esc_html__('Pick a color for header links.','visby'),
							'transparent' => false,
							'default'   => '#3a3a3a',
							'output'    => array(
								'color' => '.dnnc_slider_wrap a',
							)
						),

						array(
                            'id'          => 'visby-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Navigation Typography','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav>li>a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','visby' ),
                            'default'     => array(
                                'color'       => '#3a3a3a',
                                'font-weight'  => '700',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '18px',
                            ),
                        ),
						
						array(
							'id'        => 'visby-hover-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Navigation Links: Hover Color','visby'),
							'subtitle'  => esc_html__('Pick a hover color for header links.','visby'),
							'transparent' => false,
							'default'   => '#222',
							'output'    => array(
								'border-color' => '.nav > li.current-menu-item>a,.nav >li>a:hover,.nav li.current-menu-ancestor>a',
							)
						),
						
						array(
							'id'        => 'nordkapdnnc_borders-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Header Borders Color','visby'),
							'transparent' => false,
							'default'   => '#eee',
							'output'    => array(
								'border-color' => '#header.dnnc_border',
							)
						),
						

					
						array(
							'id'   => 'info_submenu',
							'type' => 'info',
							'title' => esc_html__('Sub-menu + Special menu button','visby'),
							'style' => 'success',
						),
						
						
						
						array(
							'id'        => 'visby-sub-bg-myheader',
							'type'      => 'color',
							'title'     => esc_html__('Sub-menu Background Color','visby'),
							'subtitle'  => esc_html__('Pick a color for header text.','visby'),
							'transparent' => false,
							'default'   => '#2e4f4f',
							'output'    => array(
								'background-color' => '.nav li ul',
								'border-left-color' => '.nav>li>ul:after,.nav > li.mega:hover::after',
								'border-right-color' => 'body.rtl .nav>li>ul:after,body.rtl .nav > li.mega:hover::after',
							)
						),


						array(
                            'id'          => 'visby-sub-header-typography',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Sub-menu Typography','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.nav ul li>a,.dnnc_tagline' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography used as navigation text.','visby' ),
                            'default'     => array(
                                'color'       => '#cbe4de',
                                'font-weight'  => '500',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '15px',
                            ),
                        ),
						

						
						
						array(
							'id'        => 'visby-special-bg',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Background Color','visby'),
							'transparent' => false,
							'default'   => '#2e4f4f',
							'output'    => array(
								'background-color' => '.nav>li.special>a,.owl-nav>div,#header .dnnc_social_icons li a',
                                
							)
						),
						
						array(
							'id'        => 'visby-special-bg-hover',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Hover Background Color','visby'),
							'transparent' => false,
							'default'   => '#2C3333',
							'output'    => array(
								'background-color' => '.nav>li.special>a:hover,.owl-nav>div:hover:hover,#header .dnnc_social_icons li a:hover',
							)
						),
						
						
						array(
							'id'        => 'visby-special-text',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Text Color','visby'),
							'transparent' => false,
							'default'   => '#cbe4de',
							'output'    => array(
								'color' => '.nav>li.special>a,.nav>li.special>a:hover i,.owl-nav>div,#header .dnnc_social_icons li a',
							)
						),
						
						
						array(
							'id'        => 'visby-special-icon',
							'type'      => 'color',
							'title'     => esc_html__('Menu Button: Icon Color','visby'),
							'transparent' => false,
							'default'   => '#0E8388',
							'output'    => array(
								'color' => '.nav>li.special>a i',
							)
						),

						array(
							'id'   => 'dnnc-info-trans',
							'type' => 'info',
							'title' => esc_html__('Transparent Header','visby'),
							'style' => 'success',
						),
						
						
						array(
							'id'        => 'visby-images-bg',
							'type'      => 'color',
							'title'     => esc_html__('Transparent Header: Background Color (fallback)','visby'),
							'transparent' => false,
							'default'   => '#1E1E1E',
							'output'    => array(
								'background-color' => '[class*="hero-cover"]  #header,.imgwrap,.dnnc_page_header_image,.post_nav_image,.tmnf_respo_magic #navigation',
                                'color' => '[class*="hero-cover"] #header .dnnc_social_icons li a',
                                )
						),
						
						
						
						array(
							'id'        => 'visby-images-text',
							'type'      => 'color',
							'title'     => esc_html__('Transparent Header: Text Color','visby'),
							'transparent' => false,
							'default'   => '#fff',
							'output'    => array(
								'color' => '[class*="hero-cover"] #titles h1 a,[class*="hero-cover"]  #header .nav > li > a,.dnnc_page_header_image,.dnnc_page_header_image p,.dnnc_page_header_image a,.dnnc_page_header_image h1,.dnnc_page_header_image .dnnc_meta a,.post_nav_image .arrow,.tmnf_respo_magic #navigation li:not(.special) a',
                                'background-color' => '[class*="hero-cover"] #header .dnnc_social_icons li a',
                            )
						),



						array(
							'id'   => 'info_spacing',
							'type' => 'info',
							'title' => esc_html__('Spacing of the Header','visby'),
							'style' => 'success',
						),

                        array(
                            'id'             => 'visby-width-header',
                            'type'           => 'dimensions',
                            'output'   => array( '#titles' ),
                            'units'          => 'px', 
                            'units_extended' => 'true',  
                            'height'          => false, 
                            'title'          => esc_html__( 'Header Title/Logo Width Option','visby' ),
                            'subtitle'       => esc_html__( 'Choose the width limitation for the header logo.','visby' ),
                            'default'        => array(
                                'width'  => '180px',
                            )
                        ),

                        array(
                            'id'       => 'visby-spacing-header',
                            'type'     => 'spacing',
                            'output'   => array( '#titles' ),
                            'mode'     => 'margin',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Title/Logo Spacing','visby' ),
                            'subtitle' => esc_html__( 'Choose the margin for the header logo.','visby' ),
                            'default'  => array(
                                'margin-top'    => '40px',
                                'margin-bottom' => '38px',
                            )
                        ),
						

                        array(
                            'id'       => 'visby-spacing-nav',
                            'type'     => 'spacing',
                            'output'   => array( '#main_menu>li>a' ),
                            'mode'     => 'padding',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Navigation Spacing (Main)','visby' ),
                            'subtitle' => esc_html__( 'Choose the margin for header navigation.','visby' ),
                            'default'  => array(
                                'padding-top'    => '20px',
                                'padding-bottom' => '20px',
                            )
                        ),
						

                        array(
                            'id'       => 'visby-spacing-nav-add',
                            'type'     => 'spacing',
                            'output'   => array( '#add_menu,#header .dnnc_social_icons' ),
                            'mode'     => 'padding',
                            'all'      => false,
                            'right'         => false,    
                            'left'          => false,     
                            'units'         => 'px',      
                            'title'    => esc_html__( 'Header Navigation Spacing (Additional)','visby' ),
                            'subtitle' => esc_html__( 'Choose the margin for header navigation.','visby' ),
                            'default'  => array(
                                'padding-top'    => '40px',
                                'padding-bottom' => '45px',
                            )
                        ),

                    )
					// section end
    ) );
	// header styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Footer Styling','visby' ),
                    'desc'   => esc_html__( '','visby' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
						array(
							'id'        => 'visby-color-myfooter',
							'type'      => 'background',
							'title'     => esc_html__('Footer: Background Color','visby'),
							'subtitle'  => esc_html__('Pick a background color for the footer.','visby'),
							'transparent' => false,
                            'output'   => array('#footer,#footer .searchform input.s,.footop-right' ),
                            'default'     => array(
                                'background-color'       => '#2c3333',
                            ),
						),
						
						array(
							'id'        => 'visby-text-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Text: Color','visby'),
							'subtitle'  => esc_html__('Pick a color for footer links.','visby'),
							'transparent' => false,
							'default'   => '#cbe4de',
							'output'    => array(
								'color' => '#footer p,#footer,#footer h4,#footer .bottom-menu a',
							)
						),
						
						array(
							'id'        => 'visby-links-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Color','visby'),
							'subtitle'  => esc_html__('Pick a color for footer links.','visby'),
							'transparent' => false,
							'default'   => '#a7bcb7',
							'output'    => array(
								'color' => '#footer a,#footer a span,#footer h2,#footer h3,#footer .meta,#footer .meta a,#footer .searchform input.s,.footop ul.social-menu li span',
							)
						),
						
						array(
							'id'        => 'visby-hover-myfooter',
							'type'      => 'color',
							'title'     => esc_html__('Footer Links: Hover Color','visby'),
							'subtitle'  => esc_html__('Pick a hover color for footer links.','visby'),
							'transparent' => false,
							'default'   => '#8bbcb6',
							'output'    => array(
								'color' => '#footer a:hover,#footer a:hover span',
							)
						),
						
						
                        array(
                            'id'       => 'visby-footer-border',
							'type'      => 'color',
							'title'     => esc_html__('Footer: Borders','visby'),
							'subtitle'  => esc_html__('Pick a color for footer borders.','visby'),
							'transparent' => false,
							'default'   => '#3d4849',
							'output'    => array(
								'border-color' => '#footer .dnnc_border,.dnnc_bck_lnk,.dnnc_foocol li,#footer a,#footer .dnnc_social_icons li a,#footer .searchform input.s,#footer input',
							)
						), 
						
						array(
							'id'   => 'info_special_footer',
							'type' => 'info',
							'title' => esc_html__('Special Footer Section (above the footer)','visby'),
							'style' => 'success',
						),	
						
						
						array(
							'id'        => 'visby-bg-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Background Color','visby'),
							'subtitle'  => esc_html__('Pick a background color for Special Footer.','visby'),
							'transparent' => false,
							'default'   => '#2e4f4f',
							'output'    => array(
								'background-color' => '.footop,.dnnc_social_icons li a:hover',
							)
						),
						
						
						array(
							'id'        => 'visby-text-color-abovefooter',
							'type'      => 'color',
							'title'     => esc_html__('Special Footer: Text / links Color','visby'),
							'subtitle'  => esc_html__('Pick a text color for Special Footer.','visby'),
							'transparent' => false,
							'default'   => '#cbe4de',
							'output'    => array(
								'color' => '#footop h2,.footop-left a,#foo-spec,#footer .dnnc_social_icons li a:hover,#footer .dnnc_social_icons li a:hover span',
							)
						),


			
						array(
                            'id'       => 'dnnc-footer-editor',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Text','visby' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','visby' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','visby' ),
							'default'  => '',
                            'validate' => 'html',
						),
						
						array(
                            'id'       => 'dnnc-footer-credits',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'Footer Credits Text','visby' ),
                            'subtitle' => esc_html__( 'Just like a text box widget.','visby' ),
                            'desc'     => esc_html__( 'This field is HTML validated!','visby' ),
							'default'  => 'Copyright © 2023 - Visby Theme',
                            'validate' => 'html',
						),
                    )

					// section end
    ) );
	// footer styling THE END
	
	
	
	
	

    Redux::setSection( $opt_name, array(                    
					'title'  => esc_html__( 'Typography','visby' ),
                    'desc'   => esc_html__( '','visby' ),
                    'icon'   => 'el el-bold',
                    'fields' => array( // header end
						
						
						array(
							'id'   => 'info_titles',
							'type' => 'info',
							'title' => esc_html__('Titles','visby'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'visby-large',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Large Titles','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.large_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for large headings (e.g. single post title).','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '900',
                                'font-family' => 'Fira Sans Condensed',
                                'google'      => true,
                                'font-size'   => '75px',
                            ),
                        ),


						array(
                            'id'          => 'visby-medium',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Medium Titles','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.medium_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '900',
                                'font-family' => 'Fira Sans Condensed',
                                'google'      => true,
                                'font-size'   => '50px',
                            ),
                        ),


						array(
                            'id'          => 'visby-small',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Small Titles','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.small_title,.post_nav_text,.tptn_title' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for small headings (e.g. footer widgets).','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '16px',
                            ),
                        ),
						
						


						array(
                            'id'          => 'visby-buttons',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Buttons Typography','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '#submit,.dnnc_social_icons li a span,.mainbutton' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '14px',
                            ),
                        ),
						
						
						
						array(
							'id'   => 'info_headings',
							'type' => 'info',
							'title' => esc_html__('Basic (in post) Headings','visby'),
							'style' => 'success',
						),	


						array(
                            'id'          => 'visby-h1',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H1 Font Style','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h1' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H1.','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '800',
                                'font-family' => 'Fira Sans Condensed',
                                'google'      => true,
                                'font-size'   => '46px',
                            ),
                        ),
						
						array(
                            'id'          => 'visby-h2',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H2 Font Style','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h2,blockquote' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H2.','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '800',
                                'font-family' => 'Fira Sans Condensed',
                                'google'      => true,
                                'font-size'   => '36px',
                            ),
                        ),
						
						array(
                            'id'          => 'visby-h3',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H3 Font Style','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h3' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H3.','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '700',
                                'font-family' => 'Fira Sans Condensed',
                                'google'      => true,
                                'font-size'   => '32px',
                            ),
                        ),
						
						array(
                            'id'          => 'visby-h4',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H4 Font Style','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h4' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H4.','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '28px',
                            ),
                        ),
						
						array(
                            'id'          => 'visby-h5',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'H5 Font Style','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( 'h5,h6' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for heading H5.','visby' ),
                            'default'     => array(
                                'color'       => '#000',
                                'font-weight'  => '600',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '22px',
                            ),
                        ),
                    )

					// section end
    ) );
	// typography styling THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Other Styling','visby' ),
                    'desc'   => esc_html__( '','visby' ),
                    'icon'   => 'el el-tint',
                    'fields' => array( // header end
						
	
						
						array(
                            'id'          => 'visby-meta',
                            'type'        => 'typography',
                            'title'       => esc_html__( 'Meta Sections: Font Style','visby' ),
                            'google'      => true,
                            'font-backup' => true,
                            'output'      => array( '.dnnc_meta,.crumb,.post_nav_text span,.dnnc_tags a' ),
                            'units'       => 'px',
                            'line-height' => false,
                            'subtitle'    => esc_html__( 'Select the typography for meta sections.','visby' ),
                            'default'     => array(
                                'color'       => '#3a3a3a',
                                'font-weight'  => '500',
                                'font-family' => 'Poppins',
                                'google'      => true,
                                'font-size'   => '10px',
                            ),
                        ),
						
						array(
							'id'        => 'visby-meta-links',
							'type'      => 'color',
							'title'     => esc_html__('Meta Sections: Links Color','visby'),
							'transparent' => false,
							'default'   => '#000',
							'output'    => array(
								'color' => '.dnnc_meta a'
								
							)
						),
						
						array(
							'id'        => 'visby-color-dividers',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Background','visby'),
							'transparent' => false,
							'default'   => '#2c3333',
							'output'    => array(
								'background-color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs',
								'color' => '.main-breadcrumbs span::after'
								
							)
						),
						
						array(
							'id'        => 'visby-color-dividers-text',
							'type'      => 'color',
							'title'     => esc_html__('Dividers: Text','visby'),
							'transparent' => false,
							'default'   => '#cbe4de',
							'output'    => array(
								'color' => 'a.mainbutton.inv,.tptn_posts_widget li::before,.dnnc_meta_categs,.dnnc_meta_categs a',
								
							)
						),
						
						array(
							'id'        => 'visby-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Color','visby'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','visby'),
							'transparent' => false,
							'default'   => '#cbe4de',
							'output'    => array(
								'background-color' => '.ribbon,a.mainbutton,.cat_nr,#respond #submit,.page-numbers.current,#submit,input[type="submit"],input.button,button.submit,#comments .navigation a,.reply a,.post_pagination_inn',
								'border-color' => 'input.button,button.submit,.page-link>span',
								
							)
						),
						
						array(
							'id'        => 'visby-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Color','visby'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','visby'),
							'transparent' => false,
							'default'   => '#2c3333',
							'output'    => array(
								'color' => '.ribbon,.ribbon a,a.ribbon,.ribbon p,#footer .ribbon,a.mainbutton,.cat_nr,.page-numbers.current,.format-quote blockquote,.reply a,#respond #submit,input[type="submit"],.post_pagination p a span',
							)
						),
						
						array(
							'id'        => 'visby-hover-color-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Background Hover Color','visby'),
							'subtitle'  => esc_html__('Pick a custom background color for main buttons, special sections, etc.','visby'),
							'transparent' => false,
							'default'   => '#2c3333',
							'output'    => array(
								'background-color' => 'a.searchSubmit:hover,.ribbon:hover,a.mainbutton:hover,.meta_more a:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,h4.widget>span:after,.post_pagination p a:hover span',
								'border-color' => 'input.button:hover,button.submit:hover,.dnnc_tags a:hover'
							)
						),
						
						array(
							'id'        => 'visby-hover-text-elements',
							'type'      => 'color',
							'title'     => esc_html__('Elements Links/Texts - Hover Color','visby'),
							'subtitle'  => esc_html__('Pick a custom text color for main buttons, special sections, etc.','visby'),
							'transparent' => false,
							'default'   => '#cbe4de',
							'output'    => array(
								'color' => '#footer a.mainbutton:hover,.ribbon:hover,.ribbon:hover a,.ribbon a:hover,.ribbon:hover p,.entry a.ribbon:hover,a.mainbutton:hover,.nav-links>a:hover,span.page-numbers:hover,.dnnc_tags a:hover,.reply a:hover,input[type="submit"]:hover,.post_pagination p a:hover span',
							)
						),
						
						

                    )
					// section end
    ) );
	// other styling THE END
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );
	
	
	
	
	//POST SETTINGS
    Redux::setSection( $opt_name, array(
                   'title'  => esc_html__( 'Post Settings','visby' ),
                    'desc'   => esc_html__( '','visby' ),
                    'icon'   => 'el el-edit',
                    'fields' => array( // header end

						
                        array(
                            'id'       => 'dnnc-post-meta-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Disable "Meta" sections','visby' ),
                            'subtitle' => esc_html__( 'Tick to disable post "information" - date, category, etc. below post titles','visby' ),
                            'desc'     => esc_html__( '','visby' ),
                            'default'  => '0'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-author-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Author Box','visby' ),
                            'desc'     => esc_html__( '','visby' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-tags-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Tags Section','visby' ),
                            'desc'     => esc_html__( '','visby' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
						
						array(
                            'id'       => 'dnnc-post-related-dis',
                            'type'     => 'checkbox',
                            'title'    => esc_html__( 'Enable Related Post Section','visby' ),
                            'desc'     => esc_html__( '','visby' ),
                            'default'  => '1'// 1 = on | 0 = off
                        ),
                    )
					// section end
    ) );
	// post settings THE END
	
	
	
	

    Redux::setSection( $opt_name, array(
                    'title'  => esc_html__( 'Social Networks','visby'),
                    'icon'   => 'el el-share',
                    'fields' => array( // header end
				
					

                        array(
                            'id'       => 'dnnc-social-rss',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Rss Feed','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
                        array(
                            'id'       => 'dnnc-social-facebook',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Facebook','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-twitter',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Twitter','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tiktok',
                            'type'     => 'text',
                            'title'    => esc_html__( 'TikTok','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-pinterest',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Pinterest','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-instagram',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Instagram','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-youtube',
                            'type'     => 'text',
                            'title'    => esc_html__( 'You Tube','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-vimeo',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Vimeo','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-tumblr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Tumblr','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-500',
                            'type'     => 'text',
                            'title'    => esc_html__( '500px','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-flickr',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Flickr','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-linkedin',
                            'type'     => 'text',
                            'title'    => esc_html__( 'LinkedIn','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
						
                        array(
                            'id'       => 'dnnc-social-foursquare',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Foursquare','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-dribbble',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Dribbble','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-skype',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Skype','visby'),
                            'subtitle' => esc_html__( 'Enter skype URL','visby'),
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-stumbleupon',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Stumbleupon','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-github',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Github','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-soundcloud',
                            'type'     => 'text',
                            'title'    => esc_html__( 'SoundCloud','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
												
                        array(
                            'id'       => 'dnnc-social-spotify',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Spotify','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-xing',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Xing','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),

                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-whatsapp',
                            'type'     => 'text',
                            'title'    => esc_html__( 'WhatsApp','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-vk',
                            'type'     => 'text',
                            'title'    => esc_html__( 'VK','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
						
												
                        array(
                            'id'       => 'dnnc-social-snapchat',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Snapchat','visby'),
                            'subtitle' => esc_html__( 'Enter full URL','visby'),
                            'validate' => 'url',
                        ),
                    )
					// section end
    ) );
	// social networks THE END	
	
	
	
	

    Redux::setSection( $opt_name, array(
					'type' => 'divide',
    ) );


    /*
     * <--- END SECTIONS
     */
