<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head><meta charset="<?php bloginfo( 'charset' ); ?>">

<!-- Set the viewport width to device width for mobile -->
<meta name="viewport" content="width=device-width, initial-scale=1" />

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php wp_head(); ?>

</head>

     
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div class="wrapper_main dnnc_border_main <?php $dannci_redux = get_option( 'dannci_redux' ); 
	if (!empty($dannci_redux['dnnc-uppercase']))  {echo esc_attr($dannci_redux['dnnc-uppercase']) . ' ';}
    if (!empty($dannci_redux['dnnc-image-filter']))  {echo esc_attr($dannci_redux['dnnc-image-filter']) . ' ';}
?>">
   
    <div id="header" class="dnnc_tranz dnnc_border_main" itemscope itemtype="http://schema.org/WPHeader">
            
        <a class="screen-reader-text ribbon skip-link" href="#content_start"><?php esc_html_e('Skip to content','visby');?></a>
    
    	<div class="dnnc_container dnnc_container_head">
        
            <div class="dnnc_column dnnc_column_12">

                <div id="titles_wrap">
                
                <div id="titles" class="tranz2">

                    <?php if(empty($dannci_redux['dnnc-main-logo']['url'])) { ?>
    
                        <h1><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name');?></a></h1>
                            
                    <?php } else { ?>  
                                
                        <a class="logo logo_main" href="<?php echo esc_url(home_url('/')); ?>">
                        
                            <img class="this_is_logo tranz" src="<?php echo esc_url($dannci_redux['dnnc-main-logo']['url']);?>" alt="<?php bloginfo('name'); ?>"/>
                            
                        </a> 
                        
                        <a class="logo logo_inv" href="<?php echo esc_url(home_url('/')); ?>">
                        
                            <img class="this_is_logo tranz" src="<?php echo esc_url($dannci_redux['dnnc-main-logo-inv']['url']);?>" alt="<?php bloginfo('name'); ?>"/>
                            
                        </a>
                                
                    <?php } ?>
                
                </div><!-- end #titles  -->
                </div><!-- end #titles_wrap  -->

                

                <div class="clearfix"></div>
                
                <div class="for-menu <?php if ( has_nav_menu( 'main-menu' ) ) {echo 'show-menu-visible';}?>">
                
                    <input type="checkbox" id="showmenu" aria-label="<?php esc_attr_e('Open Menu','visby');?>">
                    <label for="showmenu" class="show-menu ribbon" tabindex="0"><i class="fas fa-bars"></i> <span><?php esc_html_e('Menu','visby');?></span></label>
               
                    <nav id="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement" role="navigation" aria-label="<?php esc_html_e( 'Menu', 'visby' ); ?>">
                    
                        <?php get_template_part('/includes/social-icons' ); ?>
                        
                        <?php get_template_part('/includes/navigation-add'); ?>

                        <?php get_template_part('/includes/navigation'); ?>
                    
                    </nav>
                
                </div><!-- end .header-right  -->
                
            </div><!-- end .dnnc_column_12  -->
            
        </div><!-- end .dnnc_container  -->
    
    <div class="clearfix"></div>
    </div><!-- end #header  -->

<div class="clearfix"></div>
<div class="wrapper dnnc_border">