<?php get_header(); 
$dannci_redux = get_option( 'dannci_redux' );?>

<div class="dnnc_page_header dnnc_page_header_plain dnnc_border_main">
    
    <div class="dnnc_container">
    
    	<div class="dnnc_column dnnc_column_12">
        
			<?php if (is_category()) {  ?>
                <h1 class="archive_title large_title"><span class="maintitle"><?php single_cat_title(); ?></span>
                <span class="dnnc_archive_subtitle medium_title"><?php echo strip_tags(category_description()); ?> </span></h1> 
        
            <?php } elseif (is_day()) { ?>
            
                <h1 class="archive_title large_title"><span class="maintitle"><?php the_time( get_option( 'date_format' ) ); ?></span>
                <span class="dnnc_archive_subtitle medium_title"><?php esc_html_e('Archive','visby');?></span></h1>  
    
            <?php } elseif (is_month()) { ?>
            
                <h1 class="archive_title large_title"><span class="maintitle"><?php the_time( 'F, Y' ); ?></span>
                <span class="dnnc_archive_subtitle medium_title"><?php esc_html_e('Archive','visby');?></span></h1>  
    
            <?php } elseif (is_year()) { ?>
            
                <h1 class="archive_title large_title"><span class="maintitle"><?php the_time( 'Y' ); ?></span>
                <span class="dnnc_archive_subtitle medium_title"><?php esc_html_e('Archive','visby');?></span></h1>  
    
            <?php } elseif (is_author()) { ?>
            
                <h1 class="archive_title large_title"><span class="maintitle"><?php  $curauth = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author)); echo esc_attr($curauth->nickname);?></span>
                <span class="dnnc_archive_subtitle medium_title"><?php echo esc_html($curauth->user_description); ?></span></h1>
                
            <?php } elseif (is_tag()) { ?>
            
                <h1 class="archive_title large_title"><span class="maintitle"><?php echo single_tag_title( '', true); ?></span>
                <span class="dnnc_archive_subtitle medium_title"><?php esc_html_e('Tag Archive','visby');?></span></h1>  
            
            <?php } ?>
                
        </div><!-- end .dnnc_column_12  -->
        
    </div><!-- end .dnnc_container  -->
    
</div>
	



<div class="dnnc_container dnnc_container_zero">

    <div id="content_start" class="dnnc_anchor"></div>

    <div class="dnnc_box">

        <div id="content" class="dnnc_content dnnc_border_main">
                    
            <div class="dnnc_blogger dnnc_columns_wrap">

            <div class="item dnnc_column dnnc_column_12 placeholder_item"></div>
            
                <?php if (have_posts()) : ?>
                                    
                <?php while (have_posts()) : the_post();?>
                
                    <div class="item dnnc_column dnnc_column_12">
                    
                    <?php if(has_post_format('quote')){get_template_part('/post-types/post-quote-index');} 
                    
                    else {
                    
                        get_template_part('/post-types/post-classic');
                        
                    } ?>
                    
                    </div>
                        
                <?php endwhile; ?><!-- end post -->
                
                <div class="clearfix"></div>
                    
            </div><!-- end latest posts section-->
            
            <div class="clearfix"></div>
        
            <div class="pagination"><?php the_posts_pagination(); ?></div>

            <?php else : ?>
    

                    <div class="errorentry entry">
        
                        <h1 class="post entry-title" itemprop="headline"><?php esc_html_e('Nothing found here','visby');?></h1>
                    
                        <h4><?php esc_html_e('Perhaps You will find something interesting from these lists...','visby');?></h4>
                    
                        <div class="hrline"></div>
                    
                        <?php get_template_part('/includes/uni-404-content');?>
                    
                    </div>
                
                </div><!-- end latest posts section-->
                
            <?php endif; ?>               
        
            </div><!-- end #content -->

            <?php get_sidebar('left'); ?>
                
            <?php get_sidebar('right'); ?>

        </div><!-- end .dnnc_box -->
      
        <div class="clearfix"></div>
            
    </div><!-- end #content -->
    
</div><!-- end .dnnc_container -->

<div class="clearfix"></div>

<?php get_footer(); ?>